/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.PiecewiseConstantPopulation;
import dr.evolution.util.Units;
import java.util.Collections;

public class PiecewiseLinearPopulation
extends PiecewiseConstantPopulation {
    public PiecewiseLinearPopulation(Units.Type type) {
        super(type);
    }

    public PiecewiseLinearPopulation(double[] dArray, double[] dArray2, Units.Type type) {
        super(dArray, dArray2, type);
    }

    @Override
    protected final double getDemographic(int n, double d) {
        if (n == this.thetas.length - 1) {
            return this.getEpochDemographic(n);
        }
        double d2 = this.getEpochDemographic(n);
        double d3 = this.getEpochDemographic(n + 1);
        double d4 = this.getEpochDuration(n);
        assert (0.0 <= d && d <= d4);
        return d2 + d / d4 * (d3 - d2);
    }

    @Override
    public DemographicFunction getCopy() {
        PiecewiseLinearPopulation piecewiseLinearPopulation = new PiecewiseLinearPopulation(new double[this.intervals.length], new double[this.thetas.length], this.getUnits());
        System.arraycopy(this.intervals, 0, piecewiseLinearPopulation.intervals, 0, this.intervals.length);
        System.arraycopy(this.thetas, 0, piecewiseLinearPopulation.thetas, 0, this.thetas.length);
        return piecewiseLinearPopulation;
    }

    @Override
    protected final double getIntensity(int n) {
        double d = this.getEpochDemographic(n);
        double d2 = this.getEpochDemographic(n + 1);
        double d3 = this.getEpochDuration(n);
        if (d != d2) {
            return d3 * Math.log(d2 / d) / (d2 - d);
        }
        return d3 / d;
    }

    @Override
    protected final double getIntensity(int n, double d) {
        assert (d <= this.getEpochDuration(n));
        double d2 = this.getEpochDemographic(n);
        double d3 = this.getEpochDemographic(n + 1);
        double d4 = this.getEpochDuration(n);
        if (d2 != d3) {
            return d4 * Math.log(d2 * d4 / (d3 * d + d2 * (d4 - d))) / (d2 - d3);
        }
        return d / d2;
    }

    @Override
    public final double getInverseIntensity(double d) {
        if (this.cif != null) {
            int n = Collections.binarySearch(this.cif, d);
            if (n < 0) {
                if ((n = -n - 1) > 0) {
                    return (Double)this.endTime.get(n - 1) + this.getInverseIntensity(n, d - (Double)this.cif.get(n - 1));
                }
                assert (n == 0);
                return this.getInverseIntensity(0, d);
            }
            return (Double)this.endTime.get(n);
        }
        int n = 0;
        double d2 = 0.0;
        double d3 = this.getIntensity(n);
        double d4 = 0.0;
        while (d2 + d3 < d) {
            d2 += d3;
            d4 += this.getEpochDuration(n);
            d3 = this.getIntensity(++n);
        }
        return d4 += this.getInverseIntensity(n, d - d2);
    }

    private double getInverseIntensity(int n, double d) {
        double d2 = this.getEpochDemographic(n);
        double d3 = this.getEpochDemographic(n + 1);
        double d4 = this.getEpochDuration(n);
        double d5 = d3 - d2;
        double d6 = d5 != 0.0 ? d2 * d4 * (Math.exp(d * d5 / d4) - 1.0) / d5 : d * d2;
        return d6;
    }
}

