/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evomodel.branchratemodel.GridBasedBranchRateModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.discrete.DiscreteTraitBranchRateGradient;
import dr.inference.model.Parameter;
import java.util.Arrays;

public class GridBasedBranchRateModelGradient
extends DiscreteTraitBranchRateGradient {
    private final GridBasedBranchRateModel branchRateModel;
    private final int nRates;
    protected static final boolean COUNT_TOTAL_OPERATIONS = true;
    private long getGradientLogDensityCount = 0L;
    private long totalGradientTime = 0L;

    public GridBasedBranchRateModelGradient(String string, TreeDataLikelihood treeDataLikelihood, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, Parameter parameter, GridBasedBranchRateModel gridBasedBranchRateModel, boolean bl) {
        super(string, treeDataLikelihood, beagleDataLikelihoodDelegate, parameter, bl);
        this.branchRateModel = gridBasedBranchRateModel;
        this.nRates = this.branchRateModel.getGridPoints().getDimension() + 1;
    }

    @Override
    public double[] getGradientLogDensity() {
        long l = System.nanoTime();
        double[] dArray = new double[this.nRates];
        Arrays.fill(dArray, 0.0);
        double[] dArray2 = super.getGradientLogDensity();
        int n = 0;
        for (int i = 0; i < this.tree.getNodeCount(); ++i) {
            double d;
            int n2 = this.branchRateModel.getOrderedNodesIndexes(i);
            NodeRef nodeRef = this.tree.getNode(n2);
            if (this.tree.isRoot(nodeRef)) continue;
            int n3 = this.getParameterIndexFromNode(nodeRef);
            double d2 = dArray2[n3];
            double d3 = this.tree.getNodeHeight(this.tree.getNode(n2));
            double d4 = this.tree.getNodeHeight(this.tree.getParent(this.tree.getNode(n2)));
            while (n < this.nRates - 1 && this.branchRateModel.getGridPoint(n) < d3) {
                ++n;
            }
            int n4 = n;
            if (n4 < this.nRates - 1 && this.branchRateModel.getGridPoint(n4) < d4) {
                while (n4 < this.nRates - 1 && this.branchRateModel.getGridPoint(n4) < d4) {
                    d = this.branchRateModel.getSufficientStatistic(n4 + this.nRates * nodeRef.getNumber());
                    int n5 = n4++;
                    dArray[n5] = dArray[n5] + d2 * d;
                }
            }
            d = this.branchRateModel.getSufficientStatistic(n4 + this.nRates * nodeRef.getNumber());
            int n6 = n4;
            dArray[n6] = dArray[n6] + d2 * d;
        }
        ++this.getGradientLogDensityCount;
        long l2 = System.nanoTime();
        this.totalGradientTime += (l2 - l) / 1000000L;
        return dArray;
    }
}

