/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.FlexibleGrowth;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodelxml.coalescent.demographicmodel.PeakAndDeclineModelParser;
import dr.inference.model.Parameter;

public class PeakAndDeclineModel
extends DemographicModel {
    Parameter peakValueParameter = null;
    Parameter shapeParameter = null;
    Parameter peakTimeParameter = null;
    FlexibleGrowth flexibleGrowth = null;

    public PeakAndDeclineModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type) {
        this(PeakAndDeclineModelParser.PEAK_AND_DECLINE_MODEL, parameter, parameter2, parameter3, type);
    }

    public PeakAndDeclineModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type) {
        super(string);
        this.flexibleGrowth = new FlexibleGrowth(type);
        this.peakValueParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.peakTimeParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(0.0, Double.NEGATIVE_INFINITY, 1));
        this.shapeParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(0.0, Double.NEGATIVE_INFINITY, 1));
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        double d = this.peakTimeParameter.getParameterValue(0);
        double d2 = this.peakValueParameter.getParameterValue(0);
        double d3 = this.shapeParameter.getParameterValue(0);
        double d4 = d2 * (1.0 - d3) / (d3 * d);
        double d5 = -d3 / Math.pow(-d, d3 - 1.0);
        this.flexibleGrowth.setN0(d4);
        this.flexibleGrowth.setK(d5);
        this.flexibleGrowth.setR(d3);
        return this.flexibleGrowth;
    }
}

