/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.NodeRef;
import dr.evomodel.continuous.FullyConjugateMultivariateTraitLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.math.KroneckerOperation;
import dr.math.distributions.GaussianProcessRandomGenerator;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;

public class GaussianProcessFromTree
implements GaussianProcessRandomGenerator {
    private final FullyConjugateMultivariateTraitLikelihood traitModel;
    private static final boolean USE_BUFFER = true;

    public GaussianProcessFromTree(FullyConjugateMultivariateTraitLikelihood fullyConjugateMultivariateTraitLikelihood) {
        this.traitModel = fullyConjugateMultivariateTraitLikelihood;
    }

    @Override
    public Likelihood getLikelihood() {
        return this.traitModel;
    }

    @Override
    public int getDimension() {
        return this.traitModel.getTreeModel().getExternalNodeCount() * this.traitModel.getDimTrait();
    }

    @Override
    public double[][] getPrecisionMatrix() {
        double[][] dArray = this.traitModel.computeTreeVariance2(false);
        double[][] dArray2 = this.traitModel.getDiffusionModel().getPrecisionmatrix();
        Matrix matrix = new Matrix(dArray).inverse();
        double[][] dArray3 = KroneckerOperation.product(matrix.toComponents(), dArray2);
        return dArray3;
    }

    private static void scale(double[][] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            int n = 0;
            while (n < dArray[i].length) {
                double[] dArray2 = dArray[i];
                int n2 = n++;
                dArray2[n2] = dArray2[n2] * d;
            }
        }
    }

    public double getLogLikelihood() {
        return this.traitModel.getLogLikelihood();
    }

    public double[] nextRandomFast() {
        double[] dArray = new double[this.traitModel.getTreeModel().getExternalNodeCount() * this.traitModel.getDimTrait()];
        NodeRef nodeRef = this.traitModel.getTreeModel().getRoot();
        double[] dArray2 = this.traitModel.getPriorMean();
        double[][] dArray3 = null;
        double[][] dArray4 = new SymmetricMatrix(this.traitModel.getDiffusionModel().getPrecisionmatrix()).inverse().toComponents();
        try {
            dArray3 = new CholeskyDecomposition(dArray4).getL();
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        int n = this.traitModel.getDimTrait();
        int n2 = this.traitModel.getTreeModel().getNodeCount();
        double[] dArray5 = new double[(n2 + 1) * n];
        double[] dArray6 = new double[n];
        int n3 = n2 * n;
        System.arraycopy(dArray2, 0, dArray5, n3, n);
        this.nextRandomFast2(dArray5, n3, nodeRef, dArray, dArray3, dArray6);
        return dArray;
    }

    private void nextRandomFast(double[] dArray, NodeRef nodeRef, double[] dArray2, double[][] dArray3) {
        double d = this.traitModel.getTreeModel().isRoot(nodeRef) ? 1.0 / this.traitModel.getPriorSampleSize() : this.traitModel.getRescaledBranchLengthForPrecision(nodeRef);
        double d2 = Math.sqrt(d);
        double[] dArray4 = MultivariateNormalDistribution.nextMultivariateNormalCholesky(dArray, dArray3, d2);
        if (this.traitModel.getTreeModel().isExternal(nodeRef)) {
            System.arraycopy(dArray4, 0, dArray2, nodeRef.getNumber() * dArray4.length, dArray4.length);
        } else {
            int n = this.traitModel.getTreeModel().getChildCount(nodeRef);
            for (int i = 0; i < n; ++i) {
                this.nextRandomFast(dArray4, this.traitModel.getTreeModel().getChild(nodeRef, i), dArray2, dArray3);
            }
        }
    }

    private void nextRandomFast2(double[] dArray, int n, NodeRef nodeRef, double[] dArray2, double[][] dArray3, double[] dArray4) {
        int n2 = dArray3.length;
        double d = this.traitModel.getTreeModel().isRoot(nodeRef) ? 1.0 / this.traitModel.getPriorSampleSize() : this.traitModel.getRescaledBranchLengthForPrecision(nodeRef);
        double d2 = Math.sqrt(d);
        int n3 = nodeRef.getNumber() * n2;
        MultivariateNormalDistribution.nextMultivariateNormalCholesky(dArray, n, dArray3, d2, dArray, n3, dArray4);
        if (this.traitModel.getTreeModel().isExternal(nodeRef)) {
            System.arraycopy(dArray, n3, dArray2, n3, n2);
        } else {
            int n4 = this.traitModel.getTreeModel().getChildCount(nodeRef);
            for (int i = 0; i < n4; ++i) {
                this.nextRandomFast2(dArray, n3, this.traitModel.getTreeModel().getChild(nodeRef, i), dArray2, dArray3, dArray4);
            }
        }
    }

    @Override
    public Object nextRandom() {
        return this.nextRandomFast();
    }

    @Override
    public double logPdf(Object object) {
        double[] dArray = (double[])object;
        CompoundParameter compoundParameter = this.traitModel.getTraitParameter();
        for (int i = 0; i < dArray.length; ++i) {
            compoundParameter.setParameterValueQuietly(i, dArray[i]);
        }
        compoundParameter.fireParameterChangedEvent();
        return this.traitModel.getLogLikelihood();
    }
}

