/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class RateVarianceScaleOperator
extends AbstractAdaptableOperator {
    private TreeModel tree;
    private Parameter variance;
    private double scaleFactor = 0.5;

    public RateVarianceScaleOperator(TreeModel treeModel, Parameter parameter, double d, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.scaleFactor = d;
        this.tree = treeModel;
        this.variance = parameter;
    }

    @Override
    public final double doOperation() {
        double d = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        double d2 = this.variance.getParameterValue(0);
        double d3 = d * d2;
        double d4 = -Math.log(d);
        Bounds<Double> bounds = this.variance.getBounds();
        if (d3 < bounds.getLowerLimit(0) || d3 > bounds.getUpperLimit(0)) {
            return Double.NEGATIVE_INFINITY;
        }
        this.variance.setParameterValue(0, d3);
        NodeRef nodeRef = this.tree.getRoot();
        int n = nodeRef.getNumber();
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        this.getSubtree(arrayList, this.tree.getNode(n));
        double d5 = Math.sqrt(d);
        for (NodeRef nodeRef2 : arrayList) {
            d2 = this.tree.getNodeRate(nodeRef2);
            d3 = d2 * d5;
            this.tree.setNodeRate(nodeRef2, d3);
        }
        return d4 += (double)(arrayList.size() - 2) * Math.log(d5);
    }

    void getSubtree(List<NodeRef> list, NodeRef nodeRef) {
        list.add(nodeRef);
        int n = this.tree.getChildCount(nodeRef);
        for (int i = 0; i < n; ++i) {
            this.getSubtree(list, this.tree.getChild(nodeRef, i));
        }
    }

    void cleanupOperation(double d, double d2) {
    }

    @Override
    public final String getOperatorName() {
        return "rateVarianceScale";
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.exp(d) + 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    public String toString() {
        return "rateVarianceScaleOperator( [" + this.scaleFactor + ", " + 1.0 / this.scaleFactor + "]";
    }
}

