/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SitePatterns;
import dr.evolution.util.TaxonList;
import dr.inference.model.Parameter;
import dr.util.Identifiable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class SitePatternsParser
extends AbstractXMLObjectParser {
    public static final String PATTERNS = "patterns";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String EVERY = "every";
    public static final String TAXON_LIST = "taxonList";
    public static final String STRIP = "strip";
    public static final String UNIQUE = "unique";
    public static final String AMBIGUOUS_UNIQUE = "ambiguousUnique";
    public static final String AMBIGUOUS_CONSTANT = "ambiguousConstant";
    public static final String AMBIGUITY_THRESHOLD = "ambiguityThreshold";
    public static final String CONSTANT_PATTERNS = "constantPatterns";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("from", true, "The site position to start at, default is 1 (the first position)"), AttributeRule.newIntegerRule("to", true, "The site position to finish at, must be greater than <b>from</b>, default is length of given alignment"), AttributeRule.newIntegerRule("every", true, "Determines how many sites are selected. A value of 3 will select every third site starting from <b>from</b>, default is 1 (every site)"), new ElementRule("taxonList", new XMLSyntaxRule[]{new ElementRule(TaxonList.class)}, true), new ElementRule("constantPatterns", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true), new ElementRule(Alignment.class), AttributeRule.newBooleanRule("strip", true, "Strip out completely ambiguous sites"), AttributeRule.newBooleanRule("unique", true, "Return a weight list of unique patterns"), AttributeRule.newBooleanRule("ambiguousUnique", true, "Ignore ambiguity when determining unique patterns"), AttributeRule.newBooleanRule("ambiguousConstant", true, "Ignore ambiguity when determining unique constant patterns"), AttributeRule.newDoubleRule("ambiguityThreshold", true, "Threshold max proportion of ambiguous characters to allow compression")};

    @Override
    public String getParserName() {
        return PATTERNS;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        int n;
        Identifiable identifiable;
        Alignment alignment = (Alignment)xMLObject.getChild(Alignment.class);
        TaxonList taxonList = null;
        SitePatterns.CompressionType compressionType = SitePatterns.DEFAULT_COMPRESSION_TYPE;
        if (xMLObject.hasAttribute(UNIQUE) && !xMLObject.getBooleanAttribute(UNIQUE)) {
            compressionType = SitePatterns.CompressionType.UNCOMPRESSED;
        } else {
            if (xMLObject.hasAttribute(AMBIGUOUS_CONSTANT) && xMLObject.getBooleanAttribute(AMBIGUOUS_CONSTANT)) {
                compressionType = SitePatterns.CompressionType.AMBIGUOUS_CONSTANT;
            }
            if (xMLObject.hasAttribute(AMBIGUOUS_UNIQUE) && xMLObject.getBooleanAttribute(AMBIGUOUS_UNIQUE)) {
                compressionType = SitePatterns.CompressionType.AMBIGUOUS_UNIQUE;
            }
        }
        double d = xMLObject.getDoubleAttribute(AMBIGUITY_THRESHOLD, 0.5);
        if (System.getProperty("patterns.compression") != null) {
            String string = System.getProperty("patterns.compression");
            if (string.equalsIgnoreCase("off")) {
                compressionType = SitePatterns.CompressionType.UNCOMPRESSED;
            } else if (string.equalsIgnoreCase(UNIQUE)) {
                compressionType = SitePatterns.CompressionType.UNIQUE_ONLY;
            } else if (string.equalsIgnoreCase("ambiguous_constant")) {
                compressionType = SitePatterns.CompressionType.AMBIGUOUS_CONSTANT;
            } else if (string.equalsIgnoreCase("ambiguous_all")) {
                compressionType = SitePatterns.CompressionType.AMBIGUOUS_CONSTANT;
            } else {
                throw new IllegalArgumentException("Unknown `patterns.compression` system property value: " + System.getProperty("patterns.compression"));
            }
            if (System.getProperty("patterns.threshold") != null) {
                d = Double.parseDouble(System.getProperty("patterns.threshold"));
            }
        }
        int n2 = 0;
        int n3 = -1;
        int n4 = xMLObject.getAttribute(EVERY, 1);
        boolean bl = xMLObject.getAttribute(STRIP, true);
        if (xMLObject.hasAttribute(FROM) && (n2 = xMLObject.getIntegerAttribute(FROM) - 1) < 0) {
            throw new XMLParseException("illegal 'from' attribute in patterns element");
        }
        if (xMLObject.hasAttribute(TO) && ((n3 = xMLObject.getIntegerAttribute(TO) - 1) < 0 || n3 < n2)) {
            throw new XMLParseException("illegal 'to' attribute in patterns element");
        }
        if (n4 <= 0) {
            throw new XMLParseException("illegal 'every' attribute in patterns element");
        }
        if (xMLObject.hasChildNamed(TAXON_LIST)) {
            taxonList = (TaxonList)xMLObject.getElementFirstChild(TAXON_LIST);
        }
        int[] nArray = null;
        if (xMLObject.hasChildNamed(CONSTANT_PATTERNS)) {
            identifiable = (Parameter)xMLObject.getElementFirstChild(CONSTANT_PATTERNS);
            if (identifiable.getDimension() != alignment.getStateCount()) {
                throw new XMLParseException("The constantPatterns parameter length should be equal to the number of states");
            }
            nArray = new int[identifiable.getDimension()];
            n = 0;
            for (double d2 : identifiable.getParameterValues()) {
                nArray[n] = (int)d2;
                ++n;
            }
        }
        if (n2 > alignment.getSiteCount()) {
            throw new XMLParseException("illegal 'from' attribute in patterns element (selected attribute = " + n2 + " vs. actual site count = " + alignment.getSiteCount() + ")");
        }
        if (n3 > alignment.getSiteCount()) {
            throw new XMLParseException("illegal 'to' attribute in patterns element (selected attribute = " + n3 + " vs. actual site count = " + alignment.getSiteCount() + ")");
        }
        identifiable = new SitePatterns(alignment, taxonList, n2, n3, n4, bl, nArray, compressionType, d);
        n = n2 + 1;
        int n5 = n3 + 1;
        if (n3 == -1) {
            n5 = alignment.getSiteCount();
        }
        if (xMLObject.hasAttribute("id")) {
            Logger logger = Logger.getLogger("dr.evoxml");
            logger.info("\nSite patterns '" + xMLObject.getId() + "' created from positions " + Integer.toString(n) + "-" + Integer.toString(n5) + " of alignment '" + alignment.getId() + "'");
            if (n4 > 1) {
                logger.info("  only using every " + n4 + " site");
            }
            switch (compressionType) {
                case UNCOMPRESSED: {
                    logger.info("  uncompressed");
                    break;
                }
                case UNIQUE_ONLY: {
                    logger.info("  compressed to unique site patterns");
                    break;
                }
                case AMBIGUOUS_UNIQUE: {
                    logger.info("  compressed to unique site patterns allowing ambiguity");
                    break;
                }
                case AMBIGUOUS_CONSTANT: {
                    logger.info("  compressed to unique site patterns allowing ambiguity for constant sites");
                }
            }
            logger.info("  pattern count = " + ((SitePatterns)identifiable).getPatternCount());
        }
        return identifiable;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A weighted list of the unique site patterns (unique columns) in an alignment.";
    }

    @Override
    public Class getReturnType() {
        return PatternList.class;
    }
}

