/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Likelihood;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ConstantLikelihood
extends Likelihood.Abstract {
    public static final String CONSTANT_LIKELIHOOD = "constantLikelihood";
    public static final String LOG_VALUE = "logValue";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String DATA = "data";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("logValue")};

        @Override
        public String getParserName() {
            return ConstantLikelihood.CONSTANT_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getAttribute(ConstantLikelihood.LOG_VALUE, 0.0);
            return new ConstantLikelihood(d);
        }

        @Override
        public String getParserDescription() {
            return "A function that returns a constant value as a likelihood.";
        }

        @Override
        public Class getReturnType() {
            return ConstantLikelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final double logValue;

    public ConstantLikelihood(double d) {
        super(null);
        this.logValue = d;
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }

    @Override
    public double calculateLogLikelihood() {
        return this.logValue;
    }

    @Override
    public boolean evaluateEarly() {
        return true;
    }
}

