/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ForceOrderedLikelihood
extends AbstractModelLikelihood {
    private final Parameter parameter;
    private static final String FORCE_ORDERED = "forceOrderedLikelihood";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            return new ForceOrderedLikelihood(ForceOrderedLikelihood.FORCE_ORDERED, parameter);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(Parameter.class)};
        }

        @Override
        public String getParserDescription() {
            return "Likelihood that forces parameters to be in descending order";
        }

        @Override
        public Class getReturnType() {
            return ForceOrderedLikelihood.class;
        }

        @Override
        public String getParserName() {
            return ForceOrderedLikelihood.FORCE_ORDERED;
        }
    };

    public ForceOrderedLikelihood(String string, Parameter parameter) {
        super(string);
        this.parameter = parameter;
        this.addVariable(parameter);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        int n = this.parameter.getDimension();
        for (int i = 1; i < n; ++i) {
            if (!(this.parameter.getParameterValue(i) > this.parameter.getParameterValue(i - 1))) continue;
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public void makeDirty() {
    }
}

