/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.IndependentNormalDistributionModel;
import dr.inference.distribution.LatentFactorModelInterface;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.PathDependent;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.distributions.NormalDistribution;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.Vector;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LoadingsGibbsOperator
extends SimpleMCMCOperator
implements PathDependent,
GibbsOperator {
    NormalDistribution prior;
    IndependentNormalDistributionModel prior3;
    NormalDistribution workingPrior;
    LatentFactorModelInterface LFM;
    ArrayList<double[][]> precisionArray;
    ArrayList<double[]> meanMidArray;
    ArrayList<double[]> meanArray;
    boolean randomScan;
    double pathParameter = 1.0;
    final Parameter missingIndicator;
    final MatrixParameterInterface loadings;
    final boolean upperTriangle;
    double priorPrecision;
    double priorMeanPrecision;
    double priorPrecisionWorking;
    double priorMeanPrecisionWorking;
    private static boolean DEBUG = false;
    private final List<Callable<Double>> drawCallers = new ArrayList<Callable<Double>>();
    private final ExecutorService pool;

    public LoadingsGibbsOperator(LatentFactorModelInterface latentFactorModelInterface, DistributionLikelihood distributionLikelihood, IndependentNormalDistributionModel independentNormalDistributionModel, MatrixParameterInterface matrixParameterInterface, double d, boolean bl, DistributionLikelihood distributionLikelihood2, boolean bl2, int n, boolean bl3) {
        double[] dArray;
        double[][] dArray2;
        int n2;
        this.setWeight(d);
        this.upperTriangle = bl3;
        if (distributionLikelihood != null) {
            this.prior = (NormalDistribution)distributionLikelihood.getDistribution();
        } else {
            this.prior3 = independentNormalDistributionModel;
        }
        if (distributionLikelihood2 != null) {
            this.workingPrior = (NormalDistribution)distributionLikelihood2.getDistribution();
        }
        this.loadings = matrixParameterInterface != null ? matrixParameterInterface : latentFactorModelInterface.getLoadings();
        this.LFM = latentFactorModelInterface;
        this.precisionArray = new ArrayList();
        this.randomScan = bl;
        this.meanArray = new ArrayList();
        this.meanMidArray = new ArrayList();
        if (!bl) {
            for (n2 = 0; n2 < latentFactorModelInterface.getFactorDimension(); ++n2) {
                dArray2 = new double[n2 + 1][n2 + 1];
                this.precisionArray.add(dArray2);
            }
            for (n2 = 0; n2 < latentFactorModelInterface.getFactorDimension(); ++n2) {
                dArray = new double[n2 + 1];
                this.meanArray.add(dArray);
            }
            for (n2 = 0; n2 < latentFactorModelInterface.getFactorDimension(); ++n2) {
                dArray = new double[n2 + 1];
                this.meanMidArray.add(dArray);
            }
        } else {
            for (n2 = 0; n2 < latentFactorModelInterface.getFactorDimension(); ++n2) {
                dArray2 = new double[latentFactorModelInterface.getFactorDimension() - n2][latentFactorModelInterface.getFactorDimension() - n2];
                this.precisionArray.add(dArray2);
            }
            for (n2 = 0; n2 < latentFactorModelInterface.getFactorDimension(); ++n2) {
                dArray = new double[latentFactorModelInterface.getFactorDimension() - n2];
                this.meanArray.add(dArray);
            }
            for (n2 = 0; n2 < latentFactorModelInterface.getFactorDimension(); ++n2) {
                dArray = new double[latentFactorModelInterface.getFactorDimension() - n2];
                this.meanMidArray.add(dArray);
            }
        }
        if (distributionLikelihood != null) {
            this.priorPrecision = 1.0 / (this.prior.getSD() * this.prior.getSD());
            this.priorMeanPrecision = this.prior.getMean() * this.priorPrecision;
        }
        if (distributionLikelihood2 == null) {
            this.priorMeanPrecisionWorking = this.priorMeanPrecision;
            this.priorPrecisionWorking = this.priorPrecision;
        } else {
            this.priorPrecisionWorking = 1.0 / (this.workingPrior.getSD() * this.workingPrior.getSD());
            this.priorMeanPrecisionWorking = this.workingPrior.getMean() * this.priorPrecisionWorking;
        }
        if (bl2) {
            for (n2 = 0; n2 < matrixParameterInterface.getRowDimension(); ++n2) {
                if (n2 < latentFactorModelInterface.getFactorDimension() && bl3) {
                    this.drawCallers.add(new DrawCaller(n2, new double[n2 + 1][n2 + 1], new double[n2 + 1], new double[n2 + 1]));
                    continue;
                }
                this.drawCallers.add(new DrawCaller(n2, new double[latentFactorModelInterface.getFactorDimension()][latentFactorModelInterface.getFactorDimension()], new double[latentFactorModelInterface.getFactorDimension()], new double[latentFactorModelInterface.getFactorDimension()]));
            }
            n2 = n;
            this.pool = Executors.newFixedThreadPool(n2);
        } else {
            this.pool = null;
        }
        this.missingIndicator = latentFactorModelInterface.getMissingIndicator();
    }

    private void getPrecisionOfTruncated(MatrixParameterInterface matrixParameterInterface, int n, int n2, double[][] dArray) {
        int n3 = matrixParameterInterface.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                double d = 0.0;
                for (int k = 0; k < n3; ++k) {
                    if (this.missingIndicator != null && this.missingIndicator.getParameterValue(k * this.LFM.getScaledData().getRowDimension() + n2) == 1.0) continue;
                    d += matrixParameterInterface.getParameterValue(i, k) * matrixParameterInterface.getParameterValue(j, k);
                }
                dArray[i][j] = d * this.LFM.getColumnPrecision().getParameterValue(n2, n2);
                if (i == j) {
                    if (this.prior3 != null) {
                        this.priorPrecision = this.prior3.getVariance() != null ? (!this.upperTriangle ? 1.0 / this.prior3.getVariance().getParameterValue(i * this.loadings.getRowDimension() + n2) : 1.0 / this.prior3.getVariance().getParameterValue(i * this.loadings.getRowDimension() + n2)) : this.prior3.getPrecision().getParameterValue(i * this.loadings.getRowDimension() + n2);
                        if (this.workingPrior == null) {
                            this.priorMeanPrecisionWorking = this.priorMeanPrecision;
                            this.priorPrecisionWorking = this.priorPrecision;
                        }
                    }
                    dArray[i][j] = dArray[i][j] * this.pathParameter + this.getAdjustedPriorPrecision();
                    continue;
                }
                double[] dArray2 = dArray[i];
                int n4 = j;
                dArray2[n4] = dArray2[n4] * this.pathParameter;
                dArray[j][i] = dArray[i][j];
            }
        }
    }

    private void getTruncatedMean(int n, int n2, double[][] dArray, double[] dArray2, double[] dArray3, MatrixParameterInterface matrixParameterInterface) {
        int n3;
        double d;
        int n4;
        MatrixParameterInterface matrixParameterInterface2 = this.LFM.getScaledData();
        MatrixParameterInterface matrixParameterInterface3 = matrixParameterInterface;
        int n5 = matrixParameterInterface2.getColumnDimension();
        for (n4 = 0; n4 < n; ++n4) {
            d = 0.0;
            for (n3 = 0; n3 < n5; ++n3) {
                if (this.missingIndicator != null && this.missingIndicator.getParameterValue(n3 * this.LFM.getScaledData().getRowDimension() + n2) == 1.0) continue;
                d += matrixParameterInterface3.getParameterValue(n4, n3) * matrixParameterInterface2.getParameterValue(n2, n3);
            }
            d *= this.LFM.getColumnPrecision().getParameterValue(n2, n2);
            if (this.prior3 != null && this.prior3.getVariance() != null) {
                this.priorMeanPrecision = 1.0 / this.prior3.getVariance().getParameterValue(n4 * this.loadings.getRowDimension() + n2) * this.prior3.getMean().getParameterValue(n4 * this.loadings.getRowDimension() + n2);
            }
            dArray2[n4] = d += this.priorMeanPrecision;
        }
        for (n4 = 0; n4 < n; ++n4) {
            d = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d += dArray[n4][n3] * dArray2[n3];
            }
            dArray3[n4] = d;
        }
    }

    private void getPrecision(int n, double[][] dArray, MatrixParameterInterface matrixParameterInterface) {
        int n2 = this.LFM.getFactorDimension();
        if (n < n2 && this.upperTriangle) {
            this.getPrecisionOfTruncated(matrixParameterInterface, n + 1, n, dArray);
        } else {
            this.getPrecisionOfTruncated(matrixParameterInterface, n2, n, dArray);
        }
    }

    private void getMean(int n, double[][] dArray, double[] dArray2, double[] dArray3, MatrixParameterInterface matrixParameterInterface) {
        int n2 = this.LFM.getFactorDimension();
        if (n < n2 && this.upperTriangle) {
            this.getTruncatedMean(n + 1, n, dArray, dArray2, dArray3, matrixParameterInterface);
        } else {
            this.getTruncatedMean(n2, n, dArray, dArray2, dArray3, matrixParameterInterface);
        }
        int n3 = 0;
        while (n3 < dArray3.length) {
            int n4 = n3++;
            dArray3[n4] = dArray3[n4] * this.pathParameter;
        }
    }

    private void copy(int n, double[] dArray) {
        MatrixParameterInterface matrixParameterInterface = this.loadings;
        for (int i = 0; i < dArray.length; ++i) {
            matrixParameterInterface.setParameterValueQuietly(n, i, dArray[i]);
        }
    }

    private void drawI(int n, double[][] dArray, double[] dArray2, double[] dArray3, MatrixParameterInterface matrixParameterInterface) {
        double[] dArray4 = null;
        double[][] dArray5 = null;
        this.getPrecision(n, dArray, matrixParameterInterface);
        double[][] dArray6 = new SymmetricMatrix(dArray).inverse().toComponents();
        try {
            dArray5 = new CholeskyDecomposition(dArray6).getL();
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        this.getMean(n, dArray6, dArray2, dArray3, matrixParameterInterface);
        dArray4 = MultivariateNormalDistribution.nextMultivariateNormalCholesky(dArray3, dArray5);
        if (n < dArray4.length) {
            this.copy(n, dArray4);
        } else {
            this.copy(n, dArray4);
        }
        if (DEBUG) {
            System.err.println("draw: " + new Vector(dArray4));
        }
    }

    public int getStepCount() {
        return 0;
    }

    @Override
    public String getOperatorName() {
        return "loadingsGibbsOperator";
    }

    @Override
    public double doOperation() {
        Object object;
        MatrixParameterInterface matrixParameterInterface = this.LFM.getFactors();
        if (DEBUG) {
            System.err.println("Start doOp");
        }
        int n = this.loadings.getRowDimension();
        if (this.LFM.getFactorDimension() != this.precisionArray.listIterator().next().length) {
            int n2;
            if (DEBUG) {
                System.err.println("!= length");
            }
            this.precisionArray.clear();
            this.meanArray.clear();
            this.meanMidArray.clear();
            if (!this.randomScan) {
                for (n2 = 0; n2 < this.LFM.getFactorDimension(); ++n2) {
                    double[][] object22 = new double[n2 + 1][n2 + 1];
                    this.precisionArray.add(object22);
                }
                for (n2 = 0; n2 < this.LFM.getFactorDimension(); ++n2) {
                    object = new double[n2 + 1];
                    this.meanArray.add((double[])object);
                }
                for (n2 = 0; n2 < this.LFM.getFactorDimension(); ++n2) {
                    object = new double[n2 + 1];
                    this.meanMidArray.add((double[])object);
                }
            } else {
                for (n2 = 0; n2 < this.LFM.getFactorDimension(); ++n2) {
                    double[][] dArray = new double[this.LFM.getFactorDimension() - n2][this.LFM.getFactorDimension() - n2];
                    this.precisionArray.add(dArray);
                }
                for (n2 = 0; n2 < this.LFM.getFactorDimension(); ++n2) {
                    object = new double[this.LFM.getFactorDimension() - n2];
                    this.meanArray.add((double[])object);
                }
                for (n2 = 0; n2 < this.LFM.getFactorDimension(); ++n2) {
                    object = new double[this.LFM.getFactorDimension() - n2];
                    this.meanMidArray.add((double[])object);
                }
            }
        }
        if (this.pool != null) {
            if (DEBUG) {
                System.err.println("!= poll");
            }
            try {
                this.pool.invokeAll(this.drawCallers);
                this.loadings.fireParameterChangedEvent();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            double[] dArray;
            Object object2;
            Object object3;
            if (DEBUG) {
                System.err.println("inner");
            }
            if (!this.randomScan) {
                object = this.precisionArray.listIterator();
                ListIterator<double[]> listIterator = this.meanMidArray.listIterator();
                ListIterator<double[]> listIterator2 = this.meanArray.listIterator();
                object3 = new double[this.loadings.getColumnDimension()][this.loadings.getColumnDimension()];
                object2 = new double[this.loadings.getColumnDimension()];
                dArray = new double[this.loadings.getColumnDimension()];
                for (int i = 0; i < n; ++i) {
                    if (i < this.LFM.getFactorDimension() && this.upperTriangle) {
                        object3 = (double[][])object.next();
                        object2 = listIterator.next();
                        dArray = listIterator2.next();
                    }
                    this.drawI(i, (double[][])object3, (double[])object2, dArray, matrixParameterInterface);
                }
                this.loadings.fireParameterChangedEvent();
            } else {
                double[] dArray2;
                int n2 = MathUtils.nextInt(this.loadings.getRowDimension());
                if (n2 < this.LFM.getFactorDimension() && this.upperTriangle) {
                    ListIterator<double[][]> listIterator = this.precisionArray.listIterator(this.LFM.getFactorDimension() - n2 - 1);
                    object2 = listIterator.next();
                    ListIterator<double[]> listIterator3 = this.meanMidArray.listIterator(this.LFM.getFactorDimension() - n2 - 1);
                    dArray = listIterator3.next();
                    object3 = this.meanArray.listIterator(this.LFM.getFactorDimension() - n2 - 1);
                    dArray2 = (double[])object3.next();
                } else if (this.LFM.getFactorDimension() == n2) {
                    ListIterator<double[][]> listIterator = this.precisionArray.listIterator();
                    object2 = listIterator.next();
                    ListIterator<double[]> listIterator4 = this.meanMidArray.listIterator();
                    dArray = listIterator4.next();
                    object3 = this.meanArray.listIterator();
                    dArray2 = (double[])object3.next();
                } else {
                    object2 = new double[this.loadings.getColumnDimension()][this.loadings.getColumnDimension()];
                    dArray = new double[this.loadings.getColumnDimension()];
                    dArray2 = new double[this.loadings.getColumnDimension()];
                }
                this.drawI(n2, (double[][])object2, dArray, dArray2, matrixParameterInterface);
                this.loadings.fireParameterChangedEvent(n2, null);
            }
        }
        if (DEBUG) {
            for (double[] dArray : this.meanArray) {
                System.err.println(new Vector(dArray));
            }
            for (double[] dArray : this.meanMidArray) {
                System.err.println(new Vector(dArray));
            }
            for (double[][] dArray : this.precisionArray) {
                System.err.println(new Matrix(dArray));
            }
        }
        if (DEBUG) {
            System.err.println("End doOp");
        }
        return 0.0;
    }

    @Override
    public void setPathParameter(double d) {
        this.pathParameter = d;
    }

    public double getAdjustedPriorPrecision() {
        return this.priorPrecision * this.pathParameter + (1.0 - this.pathParameter) * this.priorPrecisionWorking;
    }

    class DrawCaller
    implements Callable<Double> {
        int i;
        double[][] precision;
        double[] midMean;
        double[] mean;
        private final boolean DEBUG_PARALLEL_EVALUATION = false;

        public DrawCaller(int n, double[][] dArray, double[] dArray2, double[] dArray3) {
            this.i = n;
            this.precision = dArray;
            this.midMean = dArray2;
            this.mean = dArray3;
        }

        @Override
        public Double call() throws Exception {
            MatrixParameterInterface matrixParameterInterface = LoadingsGibbsOperator.this.LFM.getFactors();
            LoadingsGibbsOperator.this.drawI(this.i, this.precision, this.midMean, this.mean, matrixParameterInterface);
            return null;
        }
    }
}

