/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.StringAttributeRule;
import dr.xml.XHTMLReport;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLParser;
import dr.xml.XMLSyntaxRule;
import java.io.PrintWriter;
import java.util.ArrayList;

public class Report
implements Reportable {
    public static final String REPORT = "report";
    public static final String FILENAME = "fileName";
    protected String title = "";
    protected ArrayList<Object> objects = new ArrayList();
    private PrintWriter writer;
    private StringBuilder buffer;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("type", "The format of the report", new String[]{"TEXT", "XHTML"}, true), new StringAttributeRule("title", "The title of the report", "Report", true), new ElementRule(Object.class, "An arbitrary mixture of text and elements to report", 1, Integer.MAX_VALUE), AttributeRule.newStringRule("fileName", true)};

        @Override
        public String getParserName() {
            return Report.REPORT;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Report report;
            if (xMLObject.hasAttribute("type")) {
                if (xMLObject.getAttribute("type").equals("TEXT")) {
                    report = new Report();
                } else {
                    if (!xMLObject.getAttribute("type").equals("XHTML")) throw new XMLParseException("unknown document type, " + xMLObject.getAttribute("type") + ", for report");
                    report = new XHTMLReport();
                }
            } else {
                report = new Report();
            }
            report.setTitle(xMLObject.getAttribute("title", ""));
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Object object = xMLObject.getChild(i);
                report.add(object);
            }
            report.setOutput(XMLParser.getFilePrintWriter(xMLObject, this.getParserName()));
            report.createReport();
            return report;
        }

        @Override
        public String getParserDescription() {
            return "Generates a report using the given text and elements";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return Report.class;
        }
    };

    public void createReport() {
        if (!this.title.equalsIgnoreCase("")) {
            this.writer.println(this.getTitle());
            this.writer.println();
        }
        this.buffer = new StringBuilder();
        for (Object object : this.objects) {
            String string = object instanceof Reportable ? ((Reportable)object).getReport() : object.toString();
            this.writer.print(string.trim());
            this.writer.print("\n");
        }
        this.writer.println();
        this.writer.flush();
    }

    public void setOutput(PrintWriter printWriter) {
        this.writer = new PrintWriter(printWriter){

            @Override
            public void print(String string) {
                super.print(string);
                Report.this.buffer.append(string);
            }

            @Override
            public void println() {
                super.println();
                Report.this.buffer.append("\n");
            }
        };
    }

    @Override
    public String getReport() {
        return this.buffer.toString();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void add(Object object) {
        this.objects.add(object);
    }
}

