/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.util.ArrayList;
import java.util.List;
import jebl.evolution.align.AlignLinearSpace;
import jebl.evolution.align.NeedlemanWunsch;
import jebl.evolution.align.Traceback;
import jebl.evolution.align.TracebackPlotter;
import jebl.evolution.align.scores.Scores;

public class NeedlemanWunschLinearSpace
extends AlignLinearSpace {
    int u;
    int[][] c;

    public NeedlemanWunschLinearSpace(Scores sub, float d) {
        super(sub, d);
    }

    public void doAlignment(String sq1, String sq2) {
        super.prepareAlignment(sq1, sq2);
        char[] s1 = sq1.toCharArray();
        char[] s2 = sq2.toCharArray();
        int n = this.n;
        int m = this.m;
        this.u = n / 2;
        this.c = new int[2][m + 1];
        float[][] score = this.sub.score;
        for (int j = 0; j <= m; ++j) {
            this.F[1][j] = -this.d * (float)j;
        }
        for (int i = 1; i <= n; ++i) {
            NeedlemanWunschLinearSpace.swap01((Object[])this.F);
            NeedlemanWunschLinearSpace.swap01((Object[])this.c);
            this.F[1][0] = -this.d * (float)i;
            for (int j = 1; j <= m; ++j) {
                float val;
                float s = score[s1[i - 1]][s2[j - 1]];
                this.F[1][j] = val = NeedlemanWunschLinearSpace.max(this.F[0][j - 1] + s, this.F[0][j] - this.d, this.F[1][j - 1] - this.d);
                if (i == this.u) {
                    this.c[1][j] = j;
                    continue;
                }
                if (val == this.F[0][j - 1] + s) {
                    this.c[1][j] = this.c[0][j - 1];
                    continue;
                }
                if (val == this.F[0][j] - this.d) {
                    this.c[1][j] = this.c[0][j];
                    continue;
                }
                if (val == this.F[1][j - 1] - this.d) {
                    this.c[1][j] = this.c[1][j - 1];
                    continue;
                }
                throw new Error("NWSmart 1");
            }
        }
    }

    public int getV() {
        return this.c[1][this.m];
    }

    public String[] getMatch() {
        int v = this.getV();
        if (this.n > 1 && this.m > 1) {
            NeedlemanWunschLinearSpace al1 = new NeedlemanWunschLinearSpace(this.sub, this.d);
            al1.doAlignment(this.seq1.substring(0, this.u), this.seq2.substring(0, v));
            NeedlemanWunschLinearSpace al2 = new NeedlemanWunschLinearSpace(this.sub, this.d);
            al2.doAlignment(this.seq1.substring(this.u), this.seq2.substring(v));
            String[] match1 = al1.getMatch();
            String[] match2 = al2.getMatch();
            return new String[]{match1[0] + match2[0], match1[1] + match2[1]};
        }
        NeedlemanWunsch al = new NeedlemanWunsch(this.sub, this.d);
        al.doAlignment(this.seq1, this.seq2);
        return al.getMatch();
    }

    public void traceback(TracebackPlotter plotter) {
        this.traceback(plotter, 0, 0, this.seq1, this.seq2);
    }

    public void traceback(TracebackPlotter plotter, int startx, int starty, String sq1, String sq2) {
        List tracebacks = this.tracebackList(startx, starty);
        plotter.newTraceBack(sq1, sq2);
        for (int i = 0; i < tracebacks.size(); ++i) {
            Traceback traceback = (Traceback)tracebacks.get(i);
            plotter.traceBack((Traceback)tracebacks.get(i));
        }
        plotter.finishedTraceBack();
    }

    private List tracebackList(int startx, int starty) {
        ArrayList tracebacks = new ArrayList();
        int v = this.getV();
        if (this.n > 1 && this.m > 1) {
            NeedlemanWunschLinearSpace al1 = new NeedlemanWunschLinearSpace(this.sub, this.d);
            al1.doAlignment(this.seq1.substring(0, this.u), this.seq2.substring(0, v));
            NeedlemanWunschLinearSpace al2 = new NeedlemanWunschLinearSpace(this.sub, this.d);
            al2.doAlignment(this.seq1.substring(this.u), this.seq2.substring(v));
            List tracebackList1 = al1.tracebackList(startx, starty);
            List tracebackList2 = al2.tracebackList(startx + this.u, starty + v);
            tracebackList1.addAll(tracebackList2);
            return tracebackList1;
        }
        NeedlemanWunsch al = new NeedlemanWunsch(this.sub, this.d);
        al.doAlignment(this.seq1, this.seq2);
        return al.tracebackList(startx, starty);
    }

    public float getScore() {
        return this.F[1][this.m];
    }
}

