/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class LocalizedText {
    private static final String LANG = "lang";
    private final List<Locale.LanguageRange> languages;
    private final Map<String, String> data = new LinkedHashMap<String, String>();

    public LocalizedText(String string) {
        this.languages = Collections.singletonList(new Locale.LanguageRange("*"));
        this.put("en", string);
    }

    public LocalizedText(List<Locale.LanguageRange> list) {
        this.languages = list;
    }

    private void put(String string, String string2) {
        if (string2 != null) {
            this.data.put(string, string2);
        }
    }

    public String getText() {
        if (this.data.isEmpty()) {
            return null;
        }
        String string = Locale.lookupTag(this.languages, this.data.keySet());
        return string != null ? this.data.get(string) : this.data.values().iterator().next();
    }

    public void setText(StartElement startElement, XMLEventReader xMLEventReader) throws XMLStreamException {
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!attribute.getName().getLocalPart().equals(LANG)) continue;
            this.put(attribute.getValue(), xMLEventReader.getElementText());
        }
    }

    public String toString() {
        return "LocalizedText [" + this.data.entrySet().stream().map(entry -> (String)entry.getKey() + " - " + (String)entry.getValue()).collect(Collectors.joining(", ")) + "]";
    }
}

