/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.set;

import choco.kernel.model.ModelException;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.set.SetVariable;
import java.util.Arrays;

public class SetConstantVariable
extends SetVariable {
    public SetConstantVariable(IntegerConstantVariable card, int ... values) {
        super(VariableType.CONSTANT_SET, false, values, NO_CONSTRAINTS_DS, card);
        this.setName(Arrays.toString(values));
        this.values = values;
    }

    @Override
    public int[] getValues() {
        return this.values;
    }

    @Override
    public int getLowB() {
        if (this.values.length > 0) {
            return this.values[0];
        }
        throw new ModelException("Cannot access lower bound of an empty set");
    }

    @Override
    public int getUppB() {
        if (this.values.length > 0) {
            return this.values[this.values.length - 1];
        }
        throw new ModelException("Cannot access lower bound of an empty set");
    }

    @Override
    public void setLowB(int lowB) {
        SetConstantVariable.throwConstantException();
    }

    @Override
    public void setUppB(int uppB) {
        SetConstantVariable.throwConstantException();
    }

    @Override
    public String pretty() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof SetConstantVariable) {
            return this.values == ((SetConstantVariable)o).getValues();
        }
        return false;
    }
}

