/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.toolkit.base.core.ucarima.estimation.McElroyEstimates;
import jdplus.tramoseats.base.core.seats.IComponentsEstimator;
import jdplus.tramoseats.base.core.seats.SeatsModel;

public class MatrixEstimator
implements IComponentsEstimator {
    private final int nfcasts;
    private final int nbcasts;

    public MatrixEstimator(int nbcasts, int nfcasts) {
        this.nfcasts = nfcasts;
        this.nbcasts = nbcasts;
    }

    @Override
    public SeriesDecomposition decompose(SeatsModel model) {
        TsData s = model.getTransformedSeries();
        SeriesDecomposition.Builder builder = SeriesDecomposition.builder((DecompositionMode)DecompositionMode.Additive);
        ComponentType[] cmps = model.componentsType();
        UcarimaModel ucm = model.compactUcarimaModel(true, true);
        McElroyEstimates mc = new McElroyEstimates();
        mc.setForecastsCount(model.extrapolationCount(this.nfcasts));
        mc.setUcarimaModel(ucm);
        mc.setData(s.getValues());
        double ser = Math.sqrt(model.getInnovationVariance());
        for (int i = 0; i < ucm.getComponentsCount(); ++i) {
            ComponentType type = cmps[i];
            double[] tmp = mc.getComponent(i);
            builder.add(TsData.ofInternal((TsPeriod)s.getStart(), (double[])tmp), type);
            tmp = mc.stdevEstimates(i);
            int j = 0;
            while (j < tmp.length) {
                int n = j++;
                tmp[n] = tmp[n] * ser;
            }
            builder.add(TsData.ofInternal((TsPeriod)s.getStart(), (double[])tmp), type, ComponentInformation.Stdev);
            tmp = mc.getForecasts(i);
            builder.add(TsData.ofInternal((TsPeriod)s.getStart(), (double[])tmp), type, ComponentInformation.Forecast);
            tmp = mc.stdevForecasts(i);
            j = 0;
            while (j < tmp.length) {
                int n = j++;
                tmp[n] = tmp[n] * ser;
            }
            builder.add(TsData.ofInternal((TsPeriod)s.getStart(), (double[])tmp), type, ComponentInformation.StdevForecast);
        }
        builder.add(s, ComponentType.Series);
        return builder.build();
    }
}

