/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling.regular;

import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MeanSpec
implements Validatable<MeanSpec> {
    private final boolean trendConstant;
    private final boolean test;
    private final Parameter coefficient;
    public static final MeanSpec DEFAULT_UNUSED = (MeanSpec)new Builder().test(false).trendConstant(false).build();
    public static final MeanSpec DEFAULT_USED = (MeanSpec)new Builder().test(false).trendConstant(true).coefficient(Parameter.undefined()).build();

    @Override
    public MeanSpec validate() throws IllegalArgumentException {
        if (this.test && Parameter.isFixed(this.coefficient)) {
            throw new IllegalArgumentException("Fixed coefficient should not be used with testing");
        }
        return this;
    }

    public boolean isUsed() {
        return this.trendConstant;
    }

    public boolean isDefined() {
        return this.trendConstant && !this.test;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_UNUSED);
    }

    public static MeanSpec none() {
        return DEFAULT_UNUSED;
    }

    public static MeanSpec mean(Parameter p) {
        return new MeanSpec(true, false, p);
    }

    public boolean hasFixedCoefficient() {
        return Parameter.isFixed(this.coefficient);
    }

    @Generated
    MeanSpec(boolean trendConstant, boolean test, Parameter coefficient) {
        this.trendConstant = trendConstant;
        this.test = test;
        this.coefficient = coefficient;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().trendConstant(this.trendConstant).test(this.test).coefficient(this.coefficient);
    }

    @Generated
    public boolean isTrendConstant() {
        return this.trendConstant;
    }

    @Generated
    public boolean isTest() {
        return this.test;
    }

    @Generated
    public Parameter getCoefficient() {
        return this.coefficient;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeanSpec)) {
            return false;
        }
        MeanSpec other = (MeanSpec)o;
        if (this.isTrendConstant() != other.isTrendConstant()) {
            return false;
        }
        if (this.isTest() != other.isTest()) {
            return false;
        }
        Parameter this$coefficient = this.getCoefficient();
        Parameter other$coefficient = other.getCoefficient();
        return !(this$coefficient == null ? other$coefficient != null : !((Object)this$coefficient).equals(other$coefficient));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTrendConstant() ? 79 : 97);
        result = result * 59 + (this.isTest() ? 79 : 97);
        Parameter $coefficient = this.getCoefficient();
        result = result * 59 + ($coefficient == null ? 43 : ((Object)$coefficient).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "MeanSpec(trendConstant=" + this.isTrendConstant() + ", test=" + this.isTest() + ", coefficient=" + String.valueOf(this.getCoefficient()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<MeanSpec> {
        @Generated
        private boolean trendConstant;
        @Generated
        private boolean test;
        @Generated
        private Parameter coefficient;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder trendConstant(boolean trendConstant) {
            this.trendConstant = trendConstant;
            return this;
        }

        @Generated
        public @NonNull Builder test(boolean test) {
            this.test = test;
            return this;
        }

        @Generated
        public @NonNull Builder coefficient(Parameter coefficient) {
            this.coefficient = coefficient;
            return this;
        }

        @Override
        @Generated
        public @NonNull MeanSpec buildWithoutValidation() {
            return new MeanSpec(this.trendConstant, this.test, this.coefficient);
        }

        @Generated
        public @NonNull String toString() {
            return "MeanSpec.Builder(trendConstant=" + this.trendConstant + ", test=" + this.test + ", coefficient=" + String.valueOf(this.coefficient) + ")";
        }
    }
}

