/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;

public class RandomSsfGenerator {
    private final Normal N;
    private FastMatrix LA;
    private final ISsf ssf;
    private final ISsfDynamics dynamics;
    private final ISsfLoading loading;
    private final ISsfError error;
    private final int n;

    private void fillRandoms(DataBlock u, RandomNumberGenerator rng) {
        for (int i = 0; i < u.length(); ++i) {
            u.set(i, this.N.random(rng));
        }
    }

    private double random(RandomNumberGenerator rng) {
        return this.N.random(rng);
    }

    public RandomSsfGenerator(ISsf ssf, double var, int n) {
        this.ssf = ssf;
        this.dynamics = ssf.dynamics();
        this.loading = ssf.loading();
        this.error = ssf.measurementError();
        this.initSsf();
        this.n = n;
        this.N = new Normal(0.0, Math.sqrt(var));
    }

    public void newSimulation(DataBlock rslt, RandomNumberGenerator rng) {
        int dim = this.ssf.getStateDim();
        DataBlock a0f = DataBlock.make(dim);
        this.generateInitialState(a0f, rng);
        DataBlock a = DataBlock.make(dim);
        this.ssf.initialization().a0(a);
        DataBlock q = DataBlock.make(this.dynamics.getInnovationsDim());
        double y = this.loading.ZX(0, a);
        if (this.error != null) {
            y += this.generateMeasurementRandom(0, rng);
        }
        DoubleSeqCursor.OnMutable cursor = rslt.cursor();
        cursor.setAndNext(y);
        for (int i = 1; i < rslt.length(); ++i) {
            this.dynamics.TX(i - 1, a);
            if (this.dynamics.hasInnovations(i - 1)) {
                this.generateTransitionRandoms(q, rng);
                this.dynamics.addSU(i - 1, a, q);
            }
            y = this.loading.ZX(i, a);
            if (this.error != null) {
                y += this.generateMeasurementRandom(i, rng);
            }
            cursor.setAndNext(y);
        }
    }

    private double lh(int pos) {
        return this.error == null ? 0.0 : Math.sqrt(this.error.at(pos));
    }

    private double h(int pos) {
        return this.error == null ? 0.0 : this.error.at(pos);
    }

    private void initSsf() {
        int dim = this.ssf.getStateDim();
        this.LA = FastMatrix.square(dim);
        this.ssf.initialization().Pf0(this.LA);
        SymmetricMatrix.lcholesky(this.LA, 1.0E-9);
    }

    private void generateTransitionRandoms(DataBlock u, RandomNumberGenerator rng) {
        this.fillRandoms(u, rng);
    }

    private double generateMeasurementRandom(int pos, RandomNumberGenerator rng) {
        double lh = this.lh(pos);
        return lh == 0.0 ? 0.0 : lh * this.random(rng);
    }

    private void generateInitialState(DataBlock a, RandomNumberGenerator rng) {
        this.fillRandoms(a, rng);
        LowerTriangularMatrix.Lx(this.LA, a);
    }
}

