/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.tramoseats.base.core.tramo.ModelController;
import jdplus.tramoseats.base.core.tramo.TramoContext;

class RegularUnderDifferencingTest
extends ModelController {
    private static final double RTVAL = 1.6;
    private static final double IM = 0.01;
    private static final double MOD = 0.9;

    RegularUnderDifferencingTest() {
    }

    @Override
    ProcessingResult process(RegSarimaModelling modelling, TramoContext context) {
        ModelDescription desc = modelling.getDescription();
        RegArimaEstimation estimation = modelling.getEstimation();
        SarimaModel cur = desc.arima();
        SarimaOrders spec = cur.orders();
        if (spec.getD() == 2 || spec.getP() == 0 || !desc.isMean()) {
            return ProcessingResult.Unchanged;
        }
        if (this.checkResiduals(estimation.getConcentratedLikelihood().e())) {
            return ProcessingResult.Unchanged;
        }
        if (!this.hasQuasiUnitRoots(cur)) {
            return ProcessingResult.Unchanged;
        }
        spec.setD(spec.getD() + 1);
        spec.setP(spec.getP() - 1);
        ModelDescription ndesc = ModelDescription.copyOf((ModelDescription)desc);
        ndesc.setSpecification(spec);
        ndesc.setMean(false);
        RegSarimaModelling ncontext = RegSarimaModelling.of((ModelDescription)ndesc);
        if (!this.estimate(ncontext, false)) {
            return ProcessingResult.Failed;
        }
        this.transferInformation(ncontext, modelling);
        return ProcessingResult.Changed;
    }

    private boolean checkResiduals(DoubleSeq e) {
        double rstd;
        double rtval;
        DataBlock res = DataBlock.of((DoubleSeq)e);
        double rm = res.sum();
        double rv = res.ssq();
        int n = res.length();
        return Math.abs(rtval = (rm /= (double)n) / (rstd = Math.sqrt((rv = rv / (double)n - rm * rm) / (double)n))) <= 1.6;
    }

    private boolean hasQuasiUnitRoots(SarimaModel m) {
        Complex[] roots = m.getRegularAR().mirror().roots();
        for (int i = 0; i < roots.length; ++i) {
            if (!(roots[i].getRe() > 0.0) || !(Math.abs(roots[i].getIm()) <= 0.01) || !(roots[i].abs() >= 0.9)) continue;
            return true;
        }
        return false;
    }
}

