/**
 * @defgroup exponential_growth_distributions Exponential Growth Distribution Functions
 * @brief Functions for exponential growth distribution calculations
 * @ingroup ode
 */

/**
 * @defgroup primary_censored_distributions Primary Censored Distributions Functions
 * @brief Functions for computing primary censored distributions
 */

/**
 * @defgroup primary_censored_single Primary Censored Distributions Functions (Single Delay)
 * @ingroup primary_censored_distributions
 * @brief Functions for computing primary censored distributions for single delays
 */

/**
 * @defgroup primary_censored_vectorized Primary Censored Distributions Functions (Vectorized)
 * @ingroup primary_censored_distributions
 * @brief Functions for computing primary censored distributions for multiple integer delays
 */

/**
 * @defgroup primary_event_analytical_distributions Analytical Solutions for Primary Event Distributions Functions
 * @brief Core functions for computing analytical solutions
 */

/**
 * @defgroup analytical_solution_helpers  Helpers for Analytical Solutions
 * @brief Helper functions for analytical solutions
 * @ingroup primary_event_analytical_distributions
 */

/**
 * @defgroup ode ODE System Functions
 * @brief Main ODE system functions
 */

/**
 * @defgroup delay_log_cdfs Log CDFs for the ode function
 * @brief Helper function to compute the log CDF for the delay distribution
 * @ingroup ode
 */

/**
 * @defgroup primary_distribution_log_pdfs Log PDFs of the primary distribution
 * @brief Helper function to compute the log PDF of the primary distribution
 * @ingroup ode
 */

