/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.api.SDMXVersion;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.SDMXClientFactory;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

class ToolCommandsFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final JTextField sasCommandText;
    private final JTextField stataCommandText;
    private final JTextField matlabCommandText;
    private final JTextField rCommandText;
    private final JTextField urlText;
    private final JLabel lblNewLabel;

    public ToolCommandsFrame(String string, String string2, String string3) throws SdmxException {
        this.setDefaultCloseOperation(2);
        this.setExtendedState(2);
        if (string2 == null || string2.isEmpty()) {
            throw new SdmxInvalidParameterException("The sdmx query is not valid yet: '" + string2 + "'");
        }
        if (string == null || string.isEmpty()) {
            throw new SdmxInvalidParameterException("The dataflow is not selected yet");
        }
        this.setResizable(false);
        this.setSize(800, 340);
        this.setLocationRelativeTo(null);
        this.setTitle("Commands in statistical tools");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setHorizontalAlignment(2);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        jMenu.add(jMenuItem);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(30, 20, 15, 20));
        this.getContentPane().add(jPanel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{30, 0};
        gridBagLayout.rowHeights = new int[]{0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0};
        gridBagLayout.rowWeights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("R:");
        jLabel.setDisplayedMnemonic('R');
        jLabel.setDisplayedMnemonicIndex(0);
        jLabel.setDisplayedMnemonic(82);
        jLabel.setFont(new Font("Calibri", 0, 13));
        jLabel.setHorizontalAlignment(4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.rCommandText = SDMXVersion.V2 == ((Provider)SDMXClientFactory.getProviders().get(string3)).getSdmxVersion() ? new JTextField("result <- getTimeSeries(provider='" + string3 + "', id='" + string + "/" + string2 + "');") : new JTextField("result <- getTimeSeries2(provider='" + string3 + "', dataflow='" + string + "', filter='" + string2 + "');");
        jLabel.setLabelFor(this.rCommandText);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        jPanel.add((Component)this.rCommandText, gridBagConstraints2);
        JLabel jLabel2 = new JLabel("MATLAB:");
        jLabel2.setDisplayedMnemonic('M');
        jLabel2.setFont(new Font("Calibri", 0, 13));
        jLabel2.setHorizontalAlignment(4);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 10);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints3);
        this.matlabCommandText = SDMXVersion.V2 == ((Provider)SDMXClientFactory.getProviders().get(string3)).getSdmxVersion() ? new JTextField("result = getTimeSeries('" + string3 + "', '" + string + "/" + string2 + "');") : new JTextField("result = getTimeSeriesTable2('" + string3 + "', '" + string + "', '', '" + string2 + "');");
        jLabel2.setLabelFor(this.matlabCommandText);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        jPanel.add((Component)this.matlabCommandText, gridBagConstraints4);
        JLabel jLabel3 = new JLabel("SAS:");
        jLabel3.setDisplayedMnemonic('S');
        jLabel3.setFont(new Font("Calibri", 0, 13));
        jLabel3.setHorizontalAlignment(4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.insets = new Insets(5, 5, 5, 10);
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        jPanel.add((Component)jLabel3, gridBagConstraints5);
        this.sasCommandText = SDMXVersion.V2 == ((Provider)SDMXClientFactory.getProviders().get(string3)).getSdmxVersion() ? new JTextField("%gettimeseries(provider=\"" + string3 + "\", tsKey=\"" + string + "/" + string2 + "\", metadata=1);") : new JTextField("NOT AVAILABLE");
        jLabel3.setLabelFor(this.sasCommandText);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 2;
        jPanel.add((Component)this.sasCommandText, gridBagConstraints6);
        JLabel jLabel4 = new JLabel("STATA:");
        jLabel4.setDisplayedMnemonic('A');
        jLabel4.setFont(new Font("Calibri", 0, 13));
        jLabel4.setHorizontalAlignment(4);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 13;
        gridBagConstraints7.insets = new Insets(5, 5, 5, 10);
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 3;
        jPanel.add((Component)jLabel4, gridBagConstraints7);
        this.stataCommandText = SDMXVersion.V2 == ((Provider)SDMXClientFactory.getProviders().get(string3)).getSdmxVersion() ? new JTextField("getTimeSeries " + string3 + " " + string + "/" + string2 + " \"\" \"\" 0 0") : new JTextField("NOT AVAILABLE");
        jLabel4.setLabelFor(this.stataCommandText);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 3;
        jPanel.add((Component)this.stataCommandText, gridBagConstraints8);
        JLabel jLabel5 = new JLabel("URL:");
        jLabel5.setDisplayedMnemonic('U');
        jLabel5.setHorizontalAlignment(4);
        jLabel5.setFont(new Font("Calibri", 0, 13));
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.insets = new Insets(5, 5, 5, 10);
        gridBagConstraints9.anchor = 13;
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 4;
        jPanel.add((Component)jLabel5, gridBagConstraints9);
        this.urlText = SDMXVersion.V2 == ((Provider)SDMXClientFactory.getProviders().get(string3)).getSdmxVersion() ? new JTextField(SdmxClientHandler.getDataURL(string3, string, string2, null, null, false, null, false)) : new JTextField(SdmxClientHandler.getDataURL(string3, string, string2, null, null, false, null, false));
        jLabel5.setLabelFor(this.urlText);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.fill = 1;
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.gridy = 4;
        jPanel.add((Component)this.urlText, gridBagConstraints10);
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(200, 60));
        jPanel2.setMinimumSize(new Dimension(0, 60));
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, 60));
        jPanel2.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.getContentPane().add((Component)jPanel2, "South");
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.lblNewLabel = new JLabel("Copied to clipboard");
        this.lblNewLabel.setVisible(false);
        this.lblNewLabel.setHorizontalAlignment(0);
        this.lblNewLabel.setForeground(Color.RED);
        this.lblNewLabel.setFont(new Font("Arial", 1, 20));
        jPanel2.add((Component)this.lblNewLabel, "Center");
        Component component = Box.createRigidArea(new Dimension(20, 20));
        jPanel2.add(component, "West");
        Component component2 = Box.createRigidArea(new Dimension(20, 20));
        jPanel2.add(component2, "East");
        for (JTextField jTextField : new JTextField[]{this.rCommandText, this.matlabCommandText, this.sasCommandText, this.stataCommandText, this.urlText}) {
            this.addListeners(jTextField);
            this.setVisuals(jTextField);
        }
        this.setVisible(true);
    }

    public void addListeners(final JTextField jTextField) {
        CaretListener caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                int n = caretEvent.getDot();
                int n2 = caretEvent.getMark();
                String string = jTextField.getText();
                String string2 = n > n2 ? string.substring(n2, n) : (n < n2 ? string.substring(n, n2) : "");
                if (!string2.isEmpty()) {
                    ToolCommandsFrame.this.clipboard.setContents(new StringSelection(string2), null);
                    ToolCommandsFrame.this.lblNewLabel.setVisible(true);
                    Timer timer = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ToolCommandsFrame.this.lblNewLabel.setVisible(false);
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jTextField.selectAll();
            }
        };
        jTextField.addCaretListener(caretListener);
        jTextField.addFocusListener(focusAdapter);
    }

    public void setVisuals(JTextField jTextField) {
        jTextField.setMinimumSize(new Dimension(7, 25));
        jTextField.setBackground(Color.WHITE);
        jTextField.setEditable(false);
        jTextField.setFont(new Font("Consolas", 0, 12));
        jTextField.setColumns(10);
    }
}

