/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDataSupplier;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class DynamicTsDataSupplier
extends TsDataSupplier {
    private final TsMoniker moniker;
    private final AtomicReference<TsData> cache;

    public DynamicTsDataSupplier(@NonNull TsMoniker moniker) {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        this.moniker = moniker;
        this.cache = new AtomicReference<Object>(null);
    }

    public DynamicTsDataSupplier(@NonNull TsMoniker moniker, @Nullable TsData current) {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        this.moniker = moniker;
        this.cache = new AtomicReference<TsData>(current);
    }

    @NonNull
    public TsMoniker getMoniker() {
        return this.moniker;
    }

    @Override
    @NonNull
    public TsData get() {
        TsData result = this.cache.get();
        if (result == null) {
            result = this.load();
            this.cache.set(result);
        }
        return result;
    }

    @NonNull
    private TsData load() {
        return TsFactory.getDefault().makeTs(this.moniker, TsInformationType.Data).getData();
    }

    public void refresh() {
        TsData newData = this.load();
        if (!newData.isEmpty() || this.cache.get() == null) {
            this.cache.set(newData);
        }
    }
}

