/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima;

import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.IRegArimaFinalizer;
import jdplus.toolkit.base.core.regarima.IRegArimaInitializer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.regarima.estimation.RegArmaEstimation;
import jdplus.toolkit.base.core.regarima.estimation.RegArmaProcessor;
import jdplus.toolkit.base.core.stats.likelihood.LogLikelihoodFunction;

public class GlsArimaProcessor<M extends IArimaModel>
implements IRegArimaComputer<M> {
    private final IRegArimaInitializer<M> initializer;
    private final IRegArimaFinalizer<M> finalizer;
    private final SsqFunctionMinimizer.Builder min;
    private final boolean ml;
    private final boolean mt;
    private final boolean fast;

    public static <N extends IArimaModel> Builder<N> builder(Class<N> nclass) {
        return new Builder();
    }

    private GlsArimaProcessor(IRegArimaInitializer<M> initializer, IRegArimaFinalizer<M> finalizer, SsqFunctionMinimizer.Builder min, double eps, boolean ml, boolean mt, boolean fast) {
        this.initializer = initializer;
        this.finalizer = finalizer;
        this.min = min == null ? LevenbergMarquardtMinimizer.builder() : min;
        this.min.functionPrecision(eps);
        this.ml = ml;
        this.mt = mt;
        this.fast = fast;
    }

    @Override
    public RegArimaEstimation<M> process(RegArimaModel<M> regs, IArimaMapping<M> mapping) {
        RegArimaModel<M> initial = this.initialize(regs, mapping);
        RegArimaEstimation<M> estimation = this.optimize(initial, mapping);
        if (estimation == null) {
            return null;
        }
        return this.finalize(estimation, mapping);
    }

    public RegArimaModel<M> initialize(RegArimaModel<M> regs, IArimaMapping<M> mapping) {
        RegArimaModel<M> start = null;
        if (this.initializer != null) {
            start = this.initializer.initialize(regs, mapping);
        }
        if (start == null) {
            return RegArimaModel.of(regs, (IArimaModel)mapping.getDefault());
        }
        return start;
    }

    public RegArimaEstimation<M> finalize(RegArimaEstimation<M> estimation, IArimaMapping<M> mapping) {
        if (this.finalizer != null) {
            return this.finalizer.finalize(estimation, mapping);
        }
        return estimation;
    }

    @Override
    public RegArimaEstimation<M> optimize(RegArimaModel<M> regs, IArimaMapping<M> mapping) {
        M arima = regs.arima();
        IArimaModel arma = (IArimaModel)arima.stationaryTransformation().getStationaryModel();
        IArimaMapping<IArimaModel> stmapping = mapping.stationaryMapping();
        RegArmaModel<M> dmodel = regs.differencedModel();
        RegArmaProcessor processor = new RegArmaProcessor(this.ml, this.mt, this.fast);
        int ndf = dmodel.getY().length() - dmodel.getX().getColumnsCount();
        RegArmaEstimation<M> rslt = processor.compute(dmodel, stmapping.parametersOf(arma), stmapping, this.min.build(), ndf);
        IArimaModel nmodel = (IArimaModel)mapping.map(rslt.getParameters());
        RegArimaModel nregs = regs.toBuilder().arima(nmodel).build();
        return RegArimaEstimation.builder().model(nregs).concentratedLikelihood(ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(nregs)).max(new LogLikelihoodFunction.Point(RegArimaEstimation.concentratedLogLikelihoodFunction(mapping, regs), rslt.getParameters(), rslt.getScore(), rslt.getInformation())).build();
    }

    public static class Builder<M extends IArimaModel> {
        private IRegArimaInitializer<M> initializer;
        private IRegArimaFinalizer<M> finalizer;
        private double eps = 1.0E-9;
        private SsqFunctionMinimizer.Builder min;
        private boolean ml = true;
        private boolean mt = false;
        private boolean fast = true;

        public Builder<M> initializer(IRegArimaInitializer<M> initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder<M> finalizer(IRegArimaFinalizer<M> finalizer) {
            this.finalizer = finalizer;
            return this;
        }

        public Builder<M> minimizer(SsqFunctionMinimizer.Builder min) {
            this.min = min;
            return this;
        }

        public Builder<M> precision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder<M> useMaximumLikelihood(boolean ml) {
            this.ml = ml;
            return this;
        }

        public Builder<M> useParallelProcessing(boolean mt) {
            this.mt = mt;
            return this;
        }

        public Builder<M> computeExactFinalDerivatives(boolean exact) {
            this.fast = !exact;
            return this;
        }

        public GlsArimaProcessor<M> build() {
            return new GlsArimaProcessor<M>(this.initializer, this.finalizer, this.min, this.eps, this.ml, this.mt, this.fast);
        }
    }
}

