/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.multivariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;
import jdplus.toolkit.base.core.ssf.multivariate.M2uAdapter;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;

public class SsfMatrix
implements IMultivariateSsfData {
    private final FastMatrix x;
    private final int nconstraints;

    public SsfMatrix(FastMatrix x) {
        this.x = x;
        this.nconstraints = 0;
    }

    public SsfMatrix(FastMatrix x, int nconstraints) {
        this.x = x;
        this.nconstraints = nconstraints;
    }

    @Override
    public double get(int pos, int v) {
        return pos < this.x.getRowsCount() ? this.x.get(pos, v) : Double.NaN;
    }

    @Override
    public boolean isMissing(int pos, int v) {
        if (pos >= this.x.getRowsCount()) {
            return true;
        }
        double y = this.x.get(pos, v);
        return !Double.isFinite(y);
    }

    @Override
    public boolean isConstraint(int pos, int v) {
        return v < this.nconstraints;
    }

    @Override
    public int getObsCount() {
        return this.x.getRowsCount();
    }

    @Override
    public int getVarsCount() {
        return this.x.getColumnsCount();
    }

    @Override
    public DoubleSeq get(int pos) {
        return pos < this.x.getRowsCount() ? this.x.row(pos) : DataBlock.EMPTY;
    }

    public ISsfData asSsfData() {
        if (this.x.getColumnsCount() == 1) {
            return new SsfData((DoubleSeq)this.x.column(0));
        }
        return M2uAdapter.of(this);
    }
}

