/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.tramoseats.base.api.seats.DecompositionSpec;
import jdplus.tramoseats.base.core.seats.DefaultBiasCorrector;
import jdplus.tramoseats.base.core.seats.DefaultModelApproximator;
import jdplus.tramoseats.base.core.seats.DefaultModelDecomposer;
import jdplus.tramoseats.base.core.seats.DefaultModelEstimator;
import jdplus.tramoseats.base.core.seats.DefaultModelValidator;
import jdplus.tramoseats.base.core.seats.IBiasCorrector;
import jdplus.tramoseats.base.core.seats.IComponentsEstimator;
import jdplus.tramoseats.base.core.seats.IModelApproximator;
import jdplus.tramoseats.base.core.seats.IModelDecomposer;
import jdplus.tramoseats.base.core.seats.IModelValidator;
import jdplus.tramoseats.base.core.seats.KalmanEstimator;
import jdplus.tramoseats.base.core.seats.WienerKolmogorovEstimator;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SeatsToolkit {
    private static final RegSarimaComputer PROCESSOR = RegSarimaComputer.builder().startingPoint(RegSarimaComputer.StartingPoint.HannanRissanen).precision(1.0E-7).build();
    private final IModelValidator modelValidator;
    private final IModelApproximator modelApproximator;
    private final IModelDecomposer modelDecomposer;
    private final IComponentsEstimator componentsEstimator;
    private final IBiasCorrector biasCorrector;

    public static SeatsToolkit of(DecompositionSpec spec) {
        DefaultModelValidator validator = DefaultModelValidator.builder().xl(spec.getXlBoundary()).build();
        DefaultModelEstimator estimator = new DefaultModelEstimator(validator, (IRegArimaComputer<SarimaModel>)PROCESSOR);
        DefaultModelDecomposer decomposer = new DefaultModelDecomposer(spec);
        DefaultModelApproximator approximator = switch (spec.getApproximationMode()) {
            case DecompositionSpec.ModelApproximationMode.None -> null;
            default -> new DefaultModelApproximator(estimator);
        };
        int nf = spec.getForecastCount();
        int nb = spec.getBackcastCount();
        return SeatsToolkit.builder().modelValidator(validator).modelApproximator(approximator).modelDecomposer(decomposer).componentsEstimator(switch (spec.getMethod()) {
            case DecompositionSpec.ComponentsEstimationMethod.KalmanSmoother -> new KalmanEstimator(nb, nf);
            default -> new WienerKolmogorovEstimator(nb, nf);
        }).biasCorrector(switch (spec.getBiasCorrection()) {
            case DecompositionSpec.BiasCorrection.Legacy -> new DefaultBiasCorrector(true);
            default -> new DefaultBiasCorrector(false);
        }).build();
    }

    @Generated
    SeatsToolkit(IModelValidator modelValidator, IModelApproximator modelApproximator, IModelDecomposer modelDecomposer, IComponentsEstimator componentsEstimator, IBiasCorrector biasCorrector) {
        this.modelValidator = modelValidator;
        this.modelApproximator = modelApproximator;
        this.modelDecomposer = modelDecomposer;
        this.componentsEstimator = componentsEstimator;
        this.biasCorrector = biasCorrector;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public IModelValidator getModelValidator() {
        return this.modelValidator;
    }

    @Generated
    public IModelApproximator getModelApproximator() {
        return this.modelApproximator;
    }

    @Generated
    public IModelDecomposer getModelDecomposer() {
        return this.modelDecomposer;
    }

    @Generated
    public IComponentsEstimator getComponentsEstimator() {
        return this.componentsEstimator;
    }

    @Generated
    public IBiasCorrector getBiasCorrector() {
        return this.biasCorrector;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeatsToolkit)) {
            return false;
        }
        SeatsToolkit other = (SeatsToolkit)o;
        IModelValidator this$modelValidator = this.getModelValidator();
        IModelValidator other$modelValidator = other.getModelValidator();
        if (this$modelValidator == null ? other$modelValidator != null : !this$modelValidator.equals(other$modelValidator)) {
            return false;
        }
        IModelApproximator this$modelApproximator = this.getModelApproximator();
        IModelApproximator other$modelApproximator = other.getModelApproximator();
        if (this$modelApproximator == null ? other$modelApproximator != null : !this$modelApproximator.equals(other$modelApproximator)) {
            return false;
        }
        IModelDecomposer this$modelDecomposer = this.getModelDecomposer();
        IModelDecomposer other$modelDecomposer = other.getModelDecomposer();
        if (this$modelDecomposer == null ? other$modelDecomposer != null : !this$modelDecomposer.equals(other$modelDecomposer)) {
            return false;
        }
        IComponentsEstimator this$componentsEstimator = this.getComponentsEstimator();
        IComponentsEstimator other$componentsEstimator = other.getComponentsEstimator();
        if (this$componentsEstimator == null ? other$componentsEstimator != null : !this$componentsEstimator.equals(other$componentsEstimator)) {
            return false;
        }
        IBiasCorrector this$biasCorrector = this.getBiasCorrector();
        IBiasCorrector other$biasCorrector = other.getBiasCorrector();
        return !(this$biasCorrector == null ? other$biasCorrector != null : !this$biasCorrector.equals(other$biasCorrector));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IModelValidator $modelValidator = this.getModelValidator();
        result = result * 59 + ($modelValidator == null ? 43 : $modelValidator.hashCode());
        IModelApproximator $modelApproximator = this.getModelApproximator();
        result = result * 59 + ($modelApproximator == null ? 43 : $modelApproximator.hashCode());
        IModelDecomposer $modelDecomposer = this.getModelDecomposer();
        result = result * 59 + ($modelDecomposer == null ? 43 : $modelDecomposer.hashCode());
        IComponentsEstimator $componentsEstimator = this.getComponentsEstimator();
        result = result * 59 + ($componentsEstimator == null ? 43 : $componentsEstimator.hashCode());
        IBiasCorrector $biasCorrector = this.getBiasCorrector();
        result = result * 59 + ($biasCorrector == null ? 43 : $biasCorrector.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SeatsToolkit(modelValidator=" + String.valueOf(this.getModelValidator()) + ", modelApproximator=" + String.valueOf(this.getModelApproximator()) + ", modelDecomposer=" + String.valueOf(this.getModelDecomposer()) + ", componentsEstimator=" + String.valueOf(this.getComponentsEstimator()) + ", biasCorrector=" + String.valueOf(this.getBiasCorrector()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private IModelValidator modelValidator;
        @Generated
        private IModelApproximator modelApproximator;
        @Generated
        private IModelDecomposer modelDecomposer;
        @Generated
        private IComponentsEstimator componentsEstimator;
        @Generated
        private IBiasCorrector biasCorrector;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder modelValidator(IModelValidator modelValidator) {
            this.modelValidator = modelValidator;
            return this;
        }

        @Generated
        public @NonNull Builder modelApproximator(IModelApproximator modelApproximator) {
            this.modelApproximator = modelApproximator;
            return this;
        }

        @Generated
        public @NonNull Builder modelDecomposer(IModelDecomposer modelDecomposer) {
            this.modelDecomposer = modelDecomposer;
            return this;
        }

        @Generated
        public @NonNull Builder componentsEstimator(IComponentsEstimator componentsEstimator) {
            this.componentsEstimator = componentsEstimator;
            return this;
        }

        @Generated
        public @NonNull Builder biasCorrector(IBiasCorrector biasCorrector) {
            this.biasCorrector = biasCorrector;
            return this;
        }

        @Generated
        public @NonNull SeatsToolkit build() {
            return new SeatsToolkit(this.modelValidator, this.modelApproximator, this.modelDecomposer, this.componentsEstimator, this.biasCorrector);
        }

        @Generated
        public @NonNull String toString() {
            return "SeatsToolkit.Builder(modelValidator=" + String.valueOf(this.modelValidator) + ", modelApproximator=" + String.valueOf(this.modelApproximator) + ", modelDecomposer=" + String.valueOf(this.modelDecomposer) + ", componentsEstimator=" + String.valueOf(this.componentsEstimator) + ", biasCorrector=" + String.valueOf(this.biasCorrector) + ")";
        }
    }
}

