/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11;

import jdplus.sa.base.api.DecompositionMode;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.api.x11.MsrTable;
import jdplus.x13.base.core.x11.filter.X11FilterFactory;
import jdplus.x13.base.core.x11.filter.endpoints.FilteredMeanEndPoints;
import lombok.Generated;

public final class X11Utility {
    public static DoubleSeq correctSeries(DoubleSeq sorig, DoubleSeq sweights, DoubleSeq salternative) {
        double[] ns = sorig.toArray();
        for (int i = 0; i < ns.length; ++i) {
            double x = sweights.get(i);
            if (x != 0.0) continue;
            ns[i] = salternative.get(i);
        }
        return DoubleSeq.of((double[])ns);
    }

    public static DoubleSeq correctSeries(DoubleSeq sorig, DoubleSeq sweights, double alternative) {
        double[] ns = sorig.toArray();
        for (int i = 0; i < ns.length; ++i) {
            double x = sweights.get(i);
            if (x != 0.0) continue;
            ns[i] = alternative;
        }
        return DoubleSeq.of((double[])ns);
    }

    public static MsrTable defaultMsrTable(DoubleSeq s, int period, int firstPeriod, DecompositionMode mode) {
        DoubleSeq is;
        SymmetricFilter filter = X11FilterFactory.makeSymmetricFilter(7);
        FilteredMeanEndPoints f = new FilteredMeanEndPoints(filter);
        int n = s.length();
        double[] x = new double[n];
        DataBlock ss = DataBlock.of((double[])x);
        for (int j = 0; j < period; ++j) {
            int nj = 1 + (n - 1 - j) / period;
            DoubleSeq bin = s.extract(j, nj, period);
            DataBlock bout = ss.extract(j, nj, period);
            f.process(bin, bout);
        }
        boolean mul = false;
        switch (mode) {
            case PseudoAdditive: {
                is = s.fn((DoubleSeq)ss, (a, b) -> a - b + 1.0);
                break;
            }
            case Multiplicative: {
                is = DoublesMath.divide((DoubleSeq)s, (DoubleSeq)ss);
                mul = true;
                break;
            }
            default: {
                is = DoublesMath.subtract((DoubleSeq)s, (DoubleSeq)ss);
            }
        }
        return MsrTable.of((DoubleSeq)ss, (DoubleSeq)is, (int)period, (int)firstPeriod, (boolean)mul);
    }

    public static double[] calcAbsMeanVariations(DoubleSeq x, int nlags, boolean mul) {
        double[] mean = new double[nlags];
        int n = x.length();
        for (int lag = 1; lag <= nlags; ++lag) {
            double sum = 0.0;
            for (int i = lag; i < n; ++i) {
                double x1 = x.get(i);
                double x0 = x.get(i - lag);
                double d = x1 - x0;
                if (mul) {
                    d /= x0;
                }
                sum += Math.abs(d);
            }
            mean[lag - 1] = sum / (double)(n - lag);
        }
        return mean;
    }

    public static double[] calcAbsMeanVariations(DoubleSeq x, int nlags, boolean mul, boolean[] valid) {
        if (valid == null) {
            return X11Utility.calcAbsMeanVariations(x, nlags, mul);
        }
        double[] mean = new double[nlags];
        for (int lag = 1; lag <= nlags; ++lag) {
            double sum = 0.0;
            int n = 0;
            for (int i = lag; i < n; ++i) {
                if (!valid[i - lag]) continue;
                ++n;
                double x1 = x.get(i);
                double x0 = x.get(i - lag);
                double d = x1 - x0;
                if (mul) {
                    d /= x0;
                }
                sum += Math.abs(d);
            }
            mean[lag - 1] = sum / (double)n;
        }
        return mean;
    }

    public static double calcAbsMeanVariation(DoubleSeq x, int lag, boolean mul) {
        double sum = 0.0;
        int n = x.length();
        for (int i = lag; i < n; ++i) {
            double x1 = x.get(i);
            double x0 = x.get(i - lag);
            double d = Math.abs(x1 - x0);
            if (mul) {
                d /= x0;
            }
            sum += d;
        }
        return sum / (double)(n - lag);
    }

    public static double calcAbsMeanVariation(DoubleSeq x, int lag, boolean mul, boolean[] valid) {
        if (valid == null) {
            return X11Utility.calcAbsMeanVariation(x, lag, mul);
        }
        double sum = 0.0;
        int n = 0;
        for (int i = lag; i < n; ++i) {
            if (!valid[i - lag]) continue;
            double x1 = x.get(i);
            double x0 = x.get(i - lag);
            double d = Math.abs(x1 - x0);
            if (mul) {
                d /= x0;
            }
            sum += d;
            ++n;
        }
        return sum / (double)n;
    }

    public static double[] calcMeanVariations(DoubleSeq x, int nlags, boolean mul) {
        double[] mean = new double[nlags];
        int n = x.length();
        for (int lag = 1; lag <= nlags; ++lag) {
            double sum = 0.0;
            for (int i = lag; i < n; ++i) {
                double x1 = x.get(i);
                double x0 = x.get(i - lag);
                double d = x1 - x0;
                if (mul) {
                    d /= x0;
                }
                sum += d;
            }
            mean[lag - 1] = sum / (double)(n - lag);
        }
        return mean;
    }

    public static double calcMeanVariation(DoubleSeq x, int lag, boolean mul) {
        int n = x.length();
        double sum = 0.0;
        for (int i = lag; i < n; ++i) {
            double x1 = x.get(i);
            double x0 = x.get(i - lag);
            double d = x1 - x0;
            if (mul) {
                d /= x0;
            }
            sum += d;
        }
        return sum / (double)(n - lag);
    }

    public static double[][] calcVariations(DoubleSeq s, int nlags, boolean mul, boolean[] valid) {
        double[] mean = new double[nlags];
        double[] std = new double[nlags];
        int iend = s.length();
        for (int l = 1; l <= nlags; ++l) {
            double sum = 0.0;
            double sum2 = 0.0;
            for (int i = l; i < iend; ++i) {
                if (valid != null && !valid[i - l]) continue;
                double x1 = s.get(i);
                double x0 = s.get(i - l);
                double d = x1 - x0;
                if (mul) {
                    d *= 100.0 / x0;
                }
                sum += d;
                sum2 += d * d;
            }
            int n = iend - l;
            mean[l - 1] = sum / (double)n;
            std[l - 1] = Math.sqrt((sum2 - sum * sum / (double)n) / (double)n);
        }
        return new double[][]{mean, std};
    }

    public static double adr(DoubleSeq x, boolean mul) {
        if (x.length() < 2) {
            return 0.0;
        }
        int n = x.length() - 1;
        double[] d = new double[n];
        DoubleSeqCursor reader = x.cursor();
        double s0 = reader.getAndNext();
        if (mul) {
            for (i = 0; i < n; ++i) {
                s1 = reader.getAndNext();
                d[i] = (s1 - s0) / s0;
                s0 = s1;
            }
        } else {
            for (i = 0; i < n; ++i) {
                s1 = reader.getAndNext();
                d[i] = s1 - s0;
                s0 = s1;
            }
        }
        int c = 0;
        int s = 0;
        for (int i = 0; i < n; ++i) {
            int cur = X11Utility.sign(d[i]);
            if (s == cur || cur == 0) continue;
            ++c;
            s = cur;
        }
        double N = n;
        return N / (double)c;
    }

    private static int sign(double val) {
        if (val < 0.0) {
            return -1;
        }
        if (val > 0.0) {
            return 1;
        }
        return 0;
    }

    @Generated
    private X11Utility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

