% Generated by roxygen2: do not edit by hand
\name{lapply}
\alias{lapply}
\alias{sapply}
\alias{vapply}
\title{Apply Over a List or Vector}
\arguments{
  \item{X}{a vector or list}
  \item{FUN}{the function to apply over X}
  \item{...}{additional arguments to FUN (optional)
}
}

\details{
Map over vector with lapply, returning a list
\code{
even_odd <- function(k) if((k \%\% 2) == 0) "even" else "odd"
lapply(1:10, even_odd)
}

Alternatively, sapply will guess at how to simplify the result
\code{sapply(1:10, even_odd)}

For safety, vapply simplifies results according to provided template
\code{vapply(1:10, even_odd, FUN.VALUE = character(1))}}

