## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(tout)

## -----------------------------------------------------------------------------
design <- tout_design(rho_0 = 0.5, rho_1 = 0.7, alpha_nom = 0.05, beta_nom  = 0.2, gamma_nom = 0.5)

design

## ----out.width="70%"----------------------------------------------------------
plot(design)

## -----------------------------------------------------------------------------
design <- tout_design(rho_0 = 0.5, rho_1 = 0.7, alpha_nom = 0.05, beta_nom  = 0.2, gamma_nom = 0.5, eta_0 = 0.3, eta_1 = 0.4)

design

## -----------------------------------------------------------------------------
design <- tout_design(rho_0 = 0.5, rho_1 = 0.7, alpha_nom = 0.05, beta_nom  = 0.2, gamma_nom = 0.5, tau = c(0.01, 0.05))

design

## -----------------------------------------------------------------------------
design <- tout_design(rho_0 = 2, rho_1 = 5, alpha_nom = 0.05, beta_nom  = 0.2, gamma_nom = 0.5, sigma = 7, tau = c(1, 2), max_n = 500)

design

