/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.alignment.SitePatterns;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.io.NewickImporter;
import dr.evolution.sequence.Sequence;
import dr.evolution.tree.Tree;
import dr.evolution.util.Date;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.branchmodel.HomogeneousBranchModel;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.siteratemodel.GammaSiteRateModel;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.nucleotide.HKY;
import dr.evomodel.tree.DefaultTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.DataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.MultiPartitionDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.PreOrderSettings;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treelikelihood.BeagleTreeLikelihood;
import dr.evomodel.treelikelihood.PartialsRescalingScheme;
import dr.inference.model.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

@Deprecated
public class DataLikelihoodTester2 {
    private static String[][] sequences = new String[][]{{"human", "chimp", "gorilla"}, {"AGAAATATGTCTGATAAAAGAGTTACTTTGATAGAGTAAATAATAGGAGCTTAAACCCCCTTATTTCTACTAGGACTATGAGAATCGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTATACCCTTCCCGTACTAAGAAATTTAGGTTAAATACAGACCAAGAGCCTTCAAAGCCCTCAGTAAGTTG-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGACCAATGGGACTTAAACCCACAAACACTTAGTTAACAGCTAAGCACCCTAATCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAA-TCACCTCGGAGCTTGGTAAAAAGAGGCCTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCCAAAGCTGGTTTCAAGCCAACCCCATGGCCTCCATGACTTTTTCAAAAGGTATTAGAAAAACCATTTCATAACTTTGTCAAAGTTAAATTATAGGCT-AAATCCTATATATCTTA-CACTGTAAAGCTAACTTAGCATTAACCTTTTAAGTTAAAGATTAAGAGAACCAACACCTCTTTACAGTGA", "AGAAATATGTCTGATAAAAGAATTACTTTGATAGAGTAAATAATAGGAGTTCAAATCCCCTTATTTCTACTAGGACTATAAGAATCGAACTCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTACACCCTTCCCGTACTAAGAAATTTAGGTTAAGCACAGACCAAGAGCCTTCAAAGCCCTCAGCAAGTTA-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATTAATGGGACTTAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAATCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAA-TCACCTCAGAGCTTGGTAAAAAGAGGCTTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCTAAAGCTGGTTTCAAGCCAACCCCATGACCTCCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAAGTTAAATTACAGGTT-AACCCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCATTAACCTTTTAAGTTAAAGATTAAGAGGACCGACACCTCTTTACAGTGA", "AGAAATATGTCTGATAAAAGAGTTACTTTGATAGAGTAAATAATAGAGGTTTAAACCCCCTTATTTCTACTAGGACTATGAGAATTGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTGTCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTCACATCCTTCCCGTACTAAGAAATTTAGGTTAAACATAGACCAAGAGCCTTCAAAGCCCTTAGTAAGTTA-CAACACTTAATTTCTGTAAGGACTGCAAAACCCTACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATCAATGGGACTCAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAGTCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAT-TCACCTCGGAGCTTGGTAAAAAGAGGCCCAGCCTCTGTCTTTAGATTTACAGTCCAATGCCTTA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCCAAAGCTGGTTTCAAGCCAACCCCATGACCTTCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAGGTTAAATTACGGGTT-AAACCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCGTTAACCTTTTAAGTTAAAGATTAAGAGTATCGGCACCTCTTTGCAGTGA"}};
    private static String[][] moreSequences = new String[][]{{"human", "chimp", "gorilla"}, {"AGGGATATGTCTGATAAAAGAGTTACTTTGATAGAGTAAATAATAGGAGCTTAAAATTTCTACTAGGACTATGAGAATCGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTATACCCTTCCCGTACTAAGAAATTTAGGTTAAATACAGACCAAGAGCCTTCAAAGCCCTCAGTAAGTTG-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGACCAATGGGACTTAAACCCACAAACACTTAGTTAACAGCTAAGCACCCTAATCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAA-TCACCTCGGAGCTTGGTAAAAAGAGGCCTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCCAAAGCTGGTTTCAAGCCAACCCCATGGCCTCCATGACTTTTTCAAAAGGTATTAGAAAAACCATTTCATAACTTTGTCAAAGTTAAATTATAGGCT-AAATCCTATATATCTTA-CACTGTAAAGCTAACTTAGCATTAACCTTTTAAGTTAAAGATTAAGAGAACCAACACCTCTTTACAGTGA", "AGCGATATGTCTGATAAAAGAATTACTTTGATAGAGTAAATAATAGGAGTTCAAAATTTCTGCTAGGTCTATACGAATCGAACTCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTACACCCTTCCCGTACTAAGAAATTTAGGTTAAGCACAGACCAAGAGCCTTCAAAGCCCTCAGCAAGTTA-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATTAATGGGACTTAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAATCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAA-TCACCTCAGAGCTTGGTAAAAAGAGGCTTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCTAAAGCTGGTTTCAAGCCAACCCCATGACCTCCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAAGTTAAATTACAGGTT-AACCCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCATTAACCTTTTAAGTTAAAGATTAAGAGGACCGACACCTCTTTACAGTGA", "AGGTATATGTCTGATAAAAGAGTTACTTTGATAGAGTAAATAATAGAGGTTTAAAATTTCTACTAGGACTATGAGAATTGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTGTCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTCACATCCTTCCCGTACTAAGAAATTTAGGTTAAACATAGACCAAGAGCCTTCAAAGCCCTTAGTAAGTTA-CAACACTTAATTTCTGTAAGGACTGCAAAACCCTACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATCAATGGGACTCAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAGTCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAT-TCACCTCGGAGCTTGGTAAAAAGAGGCCCAGCCTCTGTCTTTAGATTTACAGTCCAATGCCTTA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCCAAAGCTGGTTTCAAGCCAACCCCATGACCTTCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAGGTTAAATTACGGGTT-AAACCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCGTTAACCTTTTAAGTTAAAGATTAAGAGTATCGGCACCTCTTTGCAGTGA"}};

    public static void main(String[] stringArray) {
        MultiPartitionDataLikelihoodDelegate multiPartitionDataLikelihoodDelegate;
        TreeModel treeModel;
        Logger logger = Logger.getLogger("dr");
        logger.setUseParentHandlers(false);
        SimpleAlignment simpleAlignment = DataLikelihoodTester2.createAlignment(sequences, Nucleotides.INSTANCE);
        try {
            treeModel = DataLikelihoodTester2.createSpecifiedTree("((human:0.1,chimp:0.1):0.1,gorilla:0.2)");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to parse Newick tree");
        }
        System.out.print("\nTest BeagleTreeLikelihood (kappa = 1): ");
        Parameter.Default default_ = new Parameter.Default(new double[]{0.25, 0.25, 0.25, 0.25});
        Parameter.Default default_2 = new Parameter.Default("kappa", 1.0, 0.0, 100.0);
        FrequencyModel frequencyModel = new FrequencyModel((DataType)Nucleotides.INSTANCE, default_);
        HKY hKY = new HKY(default_2, frequencyModel);
        double d = 0.5;
        GammaSiteRateModel gammaSiteRateModel = new GammaSiteRateModel("gammaModel", d, 4);
        gammaSiteRateModel.setSubstitutionModel(hKY);
        Parameter.Default default_3 = new Parameter.Default("substitutionRate", 1.0, 0.0, Double.POSITIVE_INFINITY);
        gammaSiteRateModel.setRelativeRateParameter(default_3);
        FrequencyModel frequencyModel2 = new FrequencyModel((DataType)Nucleotides.INSTANCE, default_);
        Parameter.Default default_4 = new Parameter.Default("kappa", 10.0, 0.0, 100.0);
        HKY hKY2 = new HKY(default_4, frequencyModel2);
        GammaSiteRateModel gammaSiteRateModel2 = new GammaSiteRateModel("gammaModel", d, 4);
        gammaSiteRateModel2.setSubstitutionModel(hKY2);
        gammaSiteRateModel2.setRelativeRateParameter(default_3);
        SitePatterns sitePatterns = new SitePatterns(simpleAlignment, null, 0, -1, 1, true);
        HomogeneousBranchModel homogeneousBranchModel = new HomogeneousBranchModel(gammaSiteRateModel.getSubstitutionModel(), gammaSiteRateModel.getSubstitutionModel().getFrequencyModel());
        HomogeneousBranchModel homogeneousBranchModel2 = new HomogeneousBranchModel(gammaSiteRateModel2.getSubstitutionModel(), gammaSiteRateModel2.getSubstitutionModel().getFrequencyModel());
        DefaultBranchRateModel defaultBranchRateModel = new DefaultBranchRateModel();
        BeagleTreeLikelihood beagleTreeLikelihood = new BeagleTreeLikelihood(sitePatterns, treeModel, homogeneousBranchModel, gammaSiteRateModel, defaultBranchRateModel, null, false, PartialsRescalingScheme.AUTO, true);
        double d2 = beagleTreeLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        System.out.print("\nTest BeagleDataLikelihoodDelegate (kappa = 1): ");
        BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate = new BeagleDataLikelihoodDelegate(treeModel, sitePatterns, homogeneousBranchModel, gammaSiteRateModel, false, false, PartialsRescalingScheme.NONE, false, PreOrderSettings.getDefault());
        TreeDataLikelihood treeDataLikelihood = new TreeDataLikelihood(beagleDataLikelihoodDelegate, treeModel, defaultBranchRateModel);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        hKY.setKappa(5.0);
        System.out.print("\nTest BeagleDataLikelihoodDelegate (kappa = 5): ");
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        System.out.print("\nTest BeagleDataLikelihoodDelegate (kappa = 10): ");
        beagleDataLikelihoodDelegate = new BeagleDataLikelihoodDelegate(treeModel, sitePatterns, homogeneousBranchModel2, gammaSiteRateModel2, false, false, PartialsRescalingScheme.NONE, false, PreOrderSettings.getDefault());
        treeDataLikelihood = new TreeDataLikelihood(beagleDataLikelihoodDelegate, treeModel, defaultBranchRateModel);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        hKY2.setKappa(11.0);
        System.out.print("\nTest BeagleDataLikelihoodDelegate (kappa = 11): ");
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        hKY.setKappa(1.0);
        hKY2.setKappa(10.0);
        System.out.print("\nTest MultiPartitionDataLikelihoodDelegate 1 partition (kappa = 1):");
        try {
            multiPartitionDataLikelihoodDelegate = new MultiPartitionDataLikelihoodDelegate(treeModel, Collections.singletonList(sitePatterns), Collections.singletonList(homogeneousBranchModel), Collections.singletonList(gammaSiteRateModel), true, PartialsRescalingScheme.NONE, false);
            treeDataLikelihood = new TreeDataLikelihood(multiPartitionDataLikelihoodDelegate, treeModel, defaultBranchRateModel);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2);
        }
        catch (DataLikelihoodDelegate.DelegateTypeException delegateTypeException) {
            System.out.print("Failed to create multiPartitionDataLikelihoodDelegate instance (wrong resource type or no partitions, needs to be CUDA or OpenCL device with multiple partitions)");
        }
        hKY.setKappa(5.0);
        System.out.print("\nTest MultiPartitionDataLikelihoodDelegate 1 partition (kappa = 5):");
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        hKY.setKappa(1.0);
        System.out.print("\nTest MultiPartitionDataLikelihoodDelegate 1 partition (kappa = 10):");
        try {
            multiPartitionDataLikelihoodDelegate = new MultiPartitionDataLikelihoodDelegate(treeModel, Collections.singletonList(sitePatterns), Collections.singletonList(homogeneousBranchModel2), Collections.singletonList(gammaSiteRateModel2), true, PartialsRescalingScheme.NONE, false);
            treeDataLikelihood = new TreeDataLikelihood(multiPartitionDataLikelihoodDelegate, treeModel, defaultBranchRateModel);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2);
        }
        catch (DataLikelihoodDelegate.DelegateTypeException delegateTypeException) {
            System.out.print("Failed to create multiPartitionDataLikelihoodDelegate instance (wrong resource type or no partitions, needs to be CUDA or OpenCL device with multiple partitions)");
        }
        System.out.print("\nTest MultiPartitionDataLikelihoodDelegate 2 partitions (kappa = 1, 10): ");
        ArrayList<PatternList> arrayList = new ArrayList<PatternList>();
        arrayList.add(sitePatterns);
        arrayList.add(sitePatterns);
        ArrayList<SiteRateModel> arrayList2 = new ArrayList<SiteRateModel>();
        arrayList2.add(gammaSiteRateModel);
        arrayList2.add(gammaSiteRateModel2);
        ArrayList<BranchModel> arrayList3 = new ArrayList<BranchModel>();
        arrayList3.add(homogeneousBranchModel);
        arrayList3.add(homogeneousBranchModel2);
        try {
            multiPartitionDataLikelihoodDelegate = new MultiPartitionDataLikelihoodDelegate(treeModel, arrayList, arrayList3, arrayList2, true, PartialsRescalingScheme.NONE, false);
            treeDataLikelihood = new TreeDataLikelihood(multiPartitionDataLikelihoodDelegate, treeModel, defaultBranchRateModel);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2 + " (NOT OK: this is 2x the logLikelihood of the 2nd partition)\n\n");
        }
        catch (DataLikelihoodDelegate.DelegateTypeException delegateTypeException) {
            System.out.print("Failed to create multiPartitionDataLikelihoodDelegate instance (wrong resource type or no partitions, needs to be CUDA or OpenCL device with multiple partitions)");
        }
        System.exit(0);
        System.out.println("-- Test #1 SiteRateModels -- ");
        System.out.print("Adjust alpha in partition 1: ");
        gammaSiteRateModel.setAlpha(0.4);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        System.out.print("Return alpha in partition 1 to original value: ");
        gammaSiteRateModel.setAlpha(0.5);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2 + " (i.e. reject: OK)\n");
        System.out.print("Adjust alpha in partition 2: ");
        gammaSiteRateModel2.setAlpha(0.35);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        System.out.print("Return alpha in partition 2 to original value: ");
        gammaSiteRateModel2.setAlpha(0.5);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2 + " (i.e. reject: OK)\n");
        System.out.print("Adjust alpha in partition 1: ");
        gammaSiteRateModel.setAlpha(0.4);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        System.out.print("Adjust alpha in partition 2: ");
        gammaSiteRateModel2.setAlpha(0.35);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2 + " (NOT OK: same logLikelihood as only setting alpha in partition 2)");
        System.out.print("Return alpha in partition 1 to original value: ");
        gammaSiteRateModel.setAlpha(0.5);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2 + " (NOT OK: alpha in partition 2 has not been returned to original value yet)");
        System.out.print("Return alpha in partition 2 to original value: ");
        gammaSiteRateModel2.setAlpha(0.5);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2 + "\n");
        System.out.print("Adjust both alphas in partitions 1 and 2: ");
        gammaSiteRateModel.setAlpha(0.4);
        gammaSiteRateModel2.setAlpha(0.35);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        System.out.print("Return alpha in partition 2 to original value: ");
        gammaSiteRateModel2.setAlpha(0.5);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2 + " (NOT OK: alpha in partition 1 has not been returned to original value yet)");
        System.out.print("Return alpha in partition 1 to original value: ");
        gammaSiteRateModel.setAlpha(0.5);
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2 + "\n\n");
        System.out.println("-- Test #2 SiteRateModels -- ");
        d2 = treeDataLikelihood.getLogLikelihood();
        System.out.println("logLikelihood = " + d2);
        arrayList2 = new ArrayList();
        arrayList2.add(gammaSiteRateModel);
        try {
            multiPartitionDataLikelihoodDelegate = new MultiPartitionDataLikelihoodDelegate(treeModel, arrayList, arrayList3, arrayList2, true, PartialsRescalingScheme.NONE, false);
            treeDataLikelihood = new TreeDataLikelihood(multiPartitionDataLikelihoodDelegate, treeModel, defaultBranchRateModel);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2 + "\n");
            System.out.print("Adjust alpha in shared siteRateModel: ");
            gammaSiteRateModel.setAlpha(0.4);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2 + " (NOT OK: same logLikelihood as only adjusted alpha for partition 1)");
            gammaSiteRateModel.setAlpha(0.5);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2 + "\n\n");
        }
        catch (DataLikelihoodDelegate.DelegateTypeException delegateTypeException) {
            System.out.print("Failed to create multiPartitionDataLikelihoodDelegate instance (wrong resource type or no partitions, needs to be CUDA or OpenCL device with multiple partitions)");
        }
        System.out.println("-- Test #3 SiteRateModels -- ");
        gammaSiteRateModel = new GammaSiteRateModel("gammaModel");
        gammaSiteRateModel.setSubstitutionModel(hKY);
        gammaSiteRateModel.setRelativeRateParameter(default_3);
        gammaSiteRateModel2 = new GammaSiteRateModel("gammaModel2");
        gammaSiteRateModel2.setSubstitutionModel(hKY2);
        gammaSiteRateModel2.setRelativeRateParameter(default_3);
        arrayList2 = new ArrayList();
        arrayList2.add(gammaSiteRateModel);
        arrayList2.add(gammaSiteRateModel2);
        try {
            multiPartitionDataLikelihoodDelegate = new MultiPartitionDataLikelihoodDelegate(treeModel, arrayList, arrayList3, arrayList2, true, PartialsRescalingScheme.NONE, false);
            treeDataLikelihood = new TreeDataLikelihood(multiPartitionDataLikelihoodDelegate, treeModel, defaultBranchRateModel);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2 + "\n");
            System.out.print("Adjust kappa in partition 1: ");
            hKY.setKappa(5.0);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2 + " (NOT OK: logLikelihood has not changed?)");
            System.out.print("Return kappa in partition 1 to original value: ");
            hKY.setKappa(1.0);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2 + "\n");
            System.out.print("Adjust kappa in partition 2: ");
            hKY2.setKappa(11.0);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2);
            System.out.print("Return kappa in partition 2 to original value: ");
            hKY2.setKappa(10.0);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.println("logLikelihood = " + d2 + " (i.e. reject: OK)\n\n");
        }
        catch (DataLikelihoodDelegate.DelegateTypeException delegateTypeException) {
            System.out.print("Failed to create multiPartitionDataLikelihoodDelegate instance (wrong resource type or no partitions, needs to be CUDA or OpenCL device with multiple partitions)");
        }
        System.out.println("-- Test #4 SiteRateModels -- ");
        SimpleAlignment simpleAlignment2 = DataLikelihoodTester2.createAlignment(moreSequences, Nucleotides.INSTANCE);
        SitePatterns sitePatterns2 = new SitePatterns(simpleAlignment2, null, 0, -1, 1, true);
        BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate2 = new BeagleDataLikelihoodDelegate(treeModel, sitePatterns, homogeneousBranchModel, gammaSiteRateModel, false, false, PartialsRescalingScheme.NONE, false, PreOrderSettings.getDefault());
        TreeDataLikelihood treeDataLikelihood2 = new TreeDataLikelihood(beagleDataLikelihoodDelegate2, treeModel, defaultBranchRateModel);
        d2 = treeDataLikelihood2.getLogLikelihood();
        System.out.println("\nBeagleDataLikelihoodDelegate logLikelihood partition 1 (kappa = 1) = " + d2);
        hKY.setKappa(10.0);
        d2 = treeDataLikelihood2.getLogLikelihood();
        System.out.println("BeagleDataLikelihoodDelegate logLikelihood partition 1 (kappa = 10) = " + d2);
        hKY.setKappa(1.0);
        BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate3 = new BeagleDataLikelihoodDelegate(treeModel, sitePatterns2, homogeneousBranchModel2, gammaSiteRateModel2, false, false, PartialsRescalingScheme.NONE, false, PreOrderSettings.getDefault());
        TreeDataLikelihood treeDataLikelihood3 = new TreeDataLikelihood(beagleDataLikelihoodDelegate3, treeModel, defaultBranchRateModel);
        d2 = treeDataLikelihood3.getLogLikelihood();
        System.out.println("BeagleDataLikelihoodDelegate logLikelihood partition 2 (kappa = 10) = " + d2 + "\n");
        try {
            multiPartitionDataLikelihoodDelegate = new MultiPartitionDataLikelihoodDelegate(treeModel, Collections.singletonList(sitePatterns), Collections.singletonList(homogeneousBranchModel), Collections.singletonList(gammaSiteRateModel), true, PartialsRescalingScheme.NONE, false);
            treeDataLikelihood = new TreeDataLikelihood(multiPartitionDataLikelihoodDelegate, treeModel, defaultBranchRateModel);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.print("Test MultiPartitionDataLikelihoodDelegate 1st partition (kappa = 1):");
            System.out.println("logLikelihood = " + d2);
            hKY.setKappa(10.0);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.print("Test MultiPartitionDataLikelihoodDelegate 1st partition (kappa = 10):");
            System.out.println("logLikelihood = " + d2);
        }
        catch (DataLikelihoodDelegate.DelegateTypeException delegateTypeException) {
            System.out.print("Failed to create multiPartitionDataLikelihoodDelegate instance (wrong resource type or no partitions, needs to be CUDA or OpenCL device with multiple partitions)");
        }
        hKY.setKappa(1.0);
        try {
            multiPartitionDataLikelihoodDelegate = new MultiPartitionDataLikelihoodDelegate(treeModel, Collections.singletonList(sitePatterns2), Collections.singletonList(homogeneousBranchModel2), Collections.singletonList(gammaSiteRateModel2), true, PartialsRescalingScheme.NONE, false);
            treeDataLikelihood = new TreeDataLikelihood(multiPartitionDataLikelihoodDelegate, treeModel, defaultBranchRateModel);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.print("Test MultiPartitionDataLikelihoodDelegate 2nd partition (kappa = 10):");
            System.out.println("logLikelihood = " + d2 + "\n");
        }
        catch (DataLikelihoodDelegate.DelegateTypeException delegateTypeException) {
            System.out.print("Failed to create multiPartitionDataLikelihoodDelegate instance (wrong resource type or no partitions, needs to be CUDA or OpenCL device with multiple partitions)");
        }
        arrayList = new ArrayList();
        arrayList.add(sitePatterns);
        arrayList.add(sitePatterns2);
        try {
            multiPartitionDataLikelihoodDelegate = new MultiPartitionDataLikelihoodDelegate(treeModel, arrayList, arrayList3, arrayList2, true, PartialsRescalingScheme.NONE, false);
            treeDataLikelihood = new TreeDataLikelihood(multiPartitionDataLikelihoodDelegate, treeModel, defaultBranchRateModel);
            d2 = treeDataLikelihood.getLogLikelihood();
            System.out.print("Test MultiPartitionDataLikelihoodDelegate 2 partitions (kappa = 1, 10): ");
            System.out.println("logLikelihood = " + d2 + " (NOT OK: should be the sum of both separate logLikelihoods)\nKappa value of partition 2 is used to compute logLikelihood for both partitions?");
        }
        catch (DataLikelihoodDelegate.DelegateTypeException delegateTypeException) {
            System.out.print("Failed to create multiPartitionDataLikelihoodDelegate instance (wrong resource type or no partitions, needs to be CUDA or OpenCL device with multiple partitions)");
        }
    }

    private static SimpleAlignment createAlignment(Object[][] objectArray, DataType dataType) {
        SimpleAlignment simpleAlignment = new SimpleAlignment();
        simpleAlignment.setDataType(dataType);
        Taxon[] taxonArray = new Taxon[objectArray[0].length];
        System.out.println("Taxon len = " + objectArray[0].length);
        System.out.println("Alignment len = " + objectArray[1].length);
        if (objectArray.length > 2) {
            System.out.println("Date len = " + objectArray[2].length);
        }
        for (int i = 0; i < objectArray[0].length; ++i) {
            Serializable serializable;
            taxonArray[i] = new Taxon(objectArray[0][i].toString());
            if (objectArray.length > 2) {
                serializable = new Date((Double)objectArray[2][i], Units.Type.YEARS, (Boolean)objectArray[3][0]);
                taxonArray[i].setDate((Date)serializable);
            }
            serializable = new Sequence(objectArray[1][i].toString());
            serializable.setTaxon(taxonArray[i]);
            serializable.setDataType(dataType);
            simpleAlignment.addSequence((Sequence)serializable);
        }
        return simpleAlignment;
    }

    private static TreeModel createSpecifiedTree(String string) throws Exception {
        NewickImporter newickImporter = new NewickImporter(string);
        Tree tree = newickImporter.importTree(null);
        return new DefaultTreeModel(tree);
    }
}

