/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.AdaptableSizeFastMatrixParameter;
import dr.inference.model.MatrixSizePrior;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.PoissonDistribution;
import org.apache.commons.math.special.Beta;

public class IndianBuffetProcessPrior
extends AbstractModelLikelihood
implements MatrixSizePrior {
    boolean likelihoodKnown;
    boolean storedLikelihoodKnown;
    double logLikelihood;
    double storedLogLikelihood;
    boolean betaKnown = false;
    boolean dataKnown = false;
    boolean storedDataKnown;
    boolean storedBetaKnown;
    int[] rowCount;
    int[] storedRowCount;
    int KPlus;
    int storedKPlus;
    boolean[] containsNonZeroElements;
    boolean[] storedContainsNonZeroElements;
    double H;
    double storedH;
    int bottom;
    int storedBottom;
    double sum2;
    double storedSum2;
    int ncols;
    int storedncols;
    AdaptableSizeFastMatrixParameter data;
    Parameter alpha;
    Parameter beta;

    public IndianBuffetProcessPrior(Parameter parameter, Parameter parameter2, AdaptableSizeFastMatrixParameter adaptableSizeFastMatrixParameter) {
        super(null);
        int n;
        this.alpha = parameter;
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(parameter);
        this.beta = parameter2;
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(parameter2);
        this.data = adaptableSizeFastMatrixParameter;
        this.addVariable(adaptableSizeFastMatrixParameter);
        for (n = 0; n < adaptableSizeFastMatrixParameter.getRowDimension(); ++n) {
            if (adaptableSizeFastMatrixParameter.getParameterValue(n, 0) == 0.0) continue;
            this.containsNonZeroElements[0] = true;
        }
        for (n = 0; n < adaptableSizeFastMatrixParameter.getColumnDimension(); ++n) {
            for (int i = 0; i < adaptableSizeFastMatrixParameter.getRowDimension(); ++i) {
                int n2 = n;
                this.rowCount[n2] = (int)((double)this.rowCount[n2] + Math.abs(adaptableSizeFastMatrixParameter.getParameterValue(i, n)));
            }
        }
        this.ncols = adaptableSizeFastMatrixParameter.getColumnDimension();
    }

    private int factorial(int n) {
        if (n < 0) {
            throw new RuntimeException("Cannot take a negative factorial");
        }
        if (n == 0) {
            return 1;
        }
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 *= i + 1;
        }
        return n2;
    }

    private double H() {
        if (!this.betaKnown) {
            this.H = 0.0;
            for (int i = 0; i < this.data.getRowDimension(); ++i) {
                this.H += this.beta.getParameterValue(0) / (this.beta.getParameterValue(0) + (double)i);
            }
        }
        return this.H;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (this.ncols != this.data.getColumnDimension()) {
            int n2 = 0;
            for (int i = 0; i < this.data.getRowDimension(); ++i) {
                n2 = (int)((double)n2 + this.data.getParameterValue(i, this.data.getColumnDimension() - 1));
            }
            this.rowCount[this.data.getColumnDimension() - 1] = n2;
            this.ncols = this.data.getColumnDimension();
        } else {
            double d = this.data.getParameterValue(n);
            int n3 = n / this.data.getRowDimension();
            if (d == 0.0) {
                int n4 = n3;
                this.rowCount[n4] = this.rowCount[n4] - 1;
                if (this.rowCount[n3] == 0) {
                    this.containsNonZeroElements[n3] = false;
                }
            } else {
                int n5 = n3;
                this.rowCount[n5] = this.rowCount[n5] + 1;
                this.containsNonZeroElements[n3] = true;
            }
        }
        this.likelihoodKnown = false;
        if (variable == this.beta) {
            this.betaKnown = false;
        }
        if (variable == this.data) {
            this.dataKnown = false;
        }
    }

    @Override
    protected void storeState() {
        this.storedBetaKnown = this.betaKnown;
        this.storedContainsNonZeroElements = this.containsNonZeroElements;
        this.storedDataKnown = this.dataKnown;
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
        this.storedRowCount = this.rowCount;
        this.storedKPlus = this.KPlus;
        this.storedH = this.H;
        this.storedBottom = this.bottom;
        this.storedSum2 = this.sum2;
        this.storedncols = this.ncols;
    }

    @Override
    protected void restoreState() {
        this.betaKnown = this.storedBetaKnown;
        this.containsNonZeroElements = this.storedContainsNonZeroElements;
        this.dataKnown = this.storedDataKnown;
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        this.rowCount = this.storedRowCount;
        this.KPlus = this.storedKPlus;
        this.H = this.storedH;
        this.bottom = this.storedBottom;
        this.sum2 = this.storedSum2;
        this.ncols = this.storedncols;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    private double calculateLogLikelihood() {
        if (!this.dataKnown) {
            this.bottom = 1;
            boolean[] blArray = new boolean[this.data.getColumnDimension()];
            this.containsNonZeroElements = new boolean[this.data.getColumnDimension()];
            this.rowCount = new int[this.data.getColumnDimension()];
            for (int i = 0; i < this.data.getColumnDimension(); ++i) {
                int n = 1;
                if (!blArray[i]) {
                    for (int j = i + 1; j < this.data.getColumnDimension(); ++j) {
                        boolean bl = true;
                        if (!blArray[j]) {
                            for (int k = 0; k < this.data.getRowDimension(); ++k) {
                                if (Math.abs(this.data.getParameterValue(k, i)) == Math.abs(this.data.getParameterValue(k, j))) continue;
                                bl = false;
                            }
                        }
                        if (bl && this.containsNonZeroElements[j]) {
                            blArray[j] = true;
                            ++n;
                            continue;
                        }
                        if (this.containsNonZeroElements[j]) continue;
                        blArray[j] = true;
                    }
                }
                this.bottom *= this.factorial(n);
            }
        }
        if (!this.dataKnown || !this.betaKnown) {
            this.sum2 = 0.0;
            this.KPlus = 0;
            for (int i = 0; i < this.data.getColumnDimension(); ++i) {
                if (!this.containsNonZeroElements[i]) continue;
                ++this.KPlus;
                this.sum2 += Beta.logBeta(this.rowCount[i], (double)this.data.getRowDimension() + this.beta.getParameterValue(0) - (double)this.rowCount[i]);
            }
        }
        double d = (double)this.KPlus * Math.log(this.alpha.getParameterValue(0) * this.beta.getParameterValue(0) / (double)this.bottom);
        double d2 = -this.alpha.getParameterValue(0) * this.H();
        double d3 = this.sum2;
        this.betaKnown = true;
        this.dataKnown = true;
        return d + d2 + d3;
    }

    @Override
    public double getSizeLogLikelihood() {
        PoissonDistribution poissonDistribution = new PoissonDistribution(this.alpha.getParameterValue(0) * this.H());
        this.calculateLogLikelihood();
        return poissonDistribution.logPdf(this.KPlus) - Math.log(1.0 - Math.exp(-poissonDistribution.mean()));
    }

    public int[] getRowCount() {
        return this.rowCount;
    }

    public AdaptableSizeFastMatrixParameter getData() {
        return this.data;
    }

    @Override
    public void makeDirty() {
        this.betaKnown = false;
        this.dataKnown = false;
    }
}

