/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.EllipticalSliceOperator;
import dr.inference.operators.MCMCOperator;
import dr.math.distributions.GaussianProcessRandomGenerator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class GaussianProcessDrawOperator
extends AbstractAdaptableOperator {
    public static final String GAUSSIAN_PROCESS_OPERATOR = "gaussianProcessOperator";
    public static final String SCALE_FACTOR = "scaleFactor";
    public static final String TRANSLATION_INVARIANT = "translationInvariant";
    public static final String ROTATION_INVARIANT = "rotationInvariant";
    private double scaleFactor;
    private final Parameter parameter;
    private final GaussianProcessRandomGenerator gaussianProcess;
    private final int dim;
    private final boolean translationInvariant;
    private final boolean rotationInvariant;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("scaleFactor"), AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("autoOptimize", true), AttributeRule.newBooleanRule("translationInvariant", true), AttributeRule.newBooleanRule("rotationInvariant", true), new ElementRule(Parameter.class), new ElementRule(GaussianProcessRandomGenerator.class)};

        @Override
        public String getParserName() {
            return GaussianProcessDrawOperator.GAUSSIAN_PROCESS_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(GaussianProcessDrawOperator.SCALE_FACTOR);
            if (d2 <= 0.0) {
                throw new XMLParseException("scaleFactor must be greater than 0.0");
            }
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            GaussianProcessRandomGenerator gaussianProcessRandomGenerator = (GaussianProcessRandomGenerator)xMLObject.getChild(GaussianProcessRandomGenerator.class);
            boolean bl = xMLObject.getAttribute(GaussianProcessDrawOperator.TRANSLATION_INVARIANT, false);
            boolean bl2 = xMLObject.getAttribute(GaussianProcessDrawOperator.ROTATION_INVARIANT, false);
            return new GaussianProcessDrawOperator(parameter, d2, d, adaptationMode, gaussianProcessRandomGenerator, bl, bl2);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a multivariate normal random walk operator on a given parameter.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public GaussianProcessDrawOperator(Parameter parameter, double d, double d2, AdaptationMode adaptationMode, GaussianProcessRandomGenerator gaussianProcessRandomGenerator, boolean bl, boolean bl2) {
        super(adaptationMode);
        this.scaleFactor = d;
        this.parameter = parameter;
        this.gaussianProcess = gaussianProcessRandomGenerator;
        this.setWeight(d2);
        this.translationInvariant = bl;
        this.rotationInvariant = bl2;
        if (gaussianProcessRandomGenerator.getDimension() != parameter.getDimension()) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        this.dim = parameter.getDimension();
    }

    @Override
    public double doOperation() {
        int n;
        double[] dArray = this.parameter.getParameterValues();
        double[] dArray2 = (double[])this.gaussianProcess.nextRandom();
        for (n = 0; n < this.dim; ++n) {
            int n2 = n;
            dArray[n2] = dArray[n2] + this.scaleFactor * dArray2[n];
        }
        EllipticalSliceOperator.transformPoint(dArray, this.translationInvariant, this.rotationInvariant, 2);
        for (n = 0; n < this.dim; ++n) {
            this.parameter.setParameterValueQuietly(n, dArray[n] + this.scaleFactor * dArray2[n]);
        }
        this.parameter.fireParameterChangedEvent();
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return this.parameter.getParameterName();
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.scaleFactor);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return SCALE_FACTOR;
    }
}

