/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.LabelUtil;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.lightgbm.ObjectiveFunction;
import org.jpmml.lightgbm.Section;

public abstract class Classification
extends ObjectiveFunction {
    private int num_class_;
    public static final String CONFIG_NUM_CLASS = "num_class";

    public Classification(Section config) {
        super(config);
        this.num_class_ = config.getInt(CONFIG_NUM_CLASS);
    }

    @Override
    public Label encodeLabel(String targetName, List<?> targetCategories, ModelEncoder encoder) {
        DataField dataField;
        if (targetCategories == null) {
            targetCategories = LabelUtil.createTargetCategories((int)this.num_class_);
            dataField = encoder.createDataField(targetName, OpType.CATEGORICAL, DataType.INTEGER, targetCategories);
        } else {
            if (targetCategories.size() != this.num_class_) {
                throw new IllegalArgumentException("Expected " + this.num_class_ + " target categories, got " + targetCategories.size() + " target categories");
            }
            dataField = encoder.createDataField(targetName, OpType.CATEGORICAL, DataType.STRING, targetCategories);
        }
        return new CategoricalLabel((Field)dataField);
    }

    public int getNumClass() {
        return this.num_class_;
    }
}

