/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.seats;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.processing.GenericResults;
import jdplus.toolkit.base.api.processing.ProcResults;
import jdplus.tramoseats.base.api.seats.SeatsException;
import jdplus.tramoseats.base.api.seats.SeatsLoader;
import jdplus.tramoseats.base.api.seats.SeatsSpec;
import lombok.Generated;

public final class Seats {
    private static final SeatsLoader.Processor ENGINE = new SeatsLoader.Processor();
    private static final AtomicReference<Processor> LEGACYENGINE = new AtomicReference();

    public static void setEngine(Processor algorithm) {
        ENGINE.set(algorithm);
    }

    public static Processor getEngine() {
        return ENGINE.get();
    }

    public static ProcResults process(SeatsSpec spec, List<String> items) {
        return ENGINE.get().process(spec, items);
    }

    public static void setLegacyEngine(Processor algorithm) {
        LEGACYENGINE.set(algorithm);
    }

    public static Processor getLegacyEngine() {
        return LEGACYENGINE.get();
    }

    public static ProcResults processLegacy(SeatsSpec spec, List<String> items) {
        Processor cp = LEGACYENGINE.get();
        if (cp == null) {
            throw new SeatsException("No legacy engine");
        }
        return cp.process(spec, items);
    }

    @Generated
    private Seats() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @InterchangeableProcessor
    public static interface Processor {
        public ProcResults process(SeatsSpec var1, List<String> var2);
    }

    public static final class DefProcessor
    implements Processor {
        @Override
        public ProcResults process(SeatsSpec spec, List<String> items) {
            return GenericResults.notImplemented();
        }
    }
}

