/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.intlincomb;

import choco.cp.solver.constraints.integer.intlincomb.IntLinCombOp;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class IntLinCombEQ
extends IntLinCombOp {
    public IntLinCombEQ(int[] coeffs, int nbPosVars, int cste, IntDomainVar[] vars, AbstractSConstraint constraint) {
        super(coeffs, nbPosVars, cste, vars, constraint);
    }

    @Override
    public Boolean isEntailed() {
        int a = this.coeffPolicy.computeLowerBound();
        int b = this.coeffPolicy.computeUpperBound();
        if (b < 0 || a > 0) {
            return Boolean.FALSE;
        }
        if (a == 0 && b == 0) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.compute(tuple) == 0;
    }

    @Override
    public boolean filterOnImprovedLowerBound() throws ContradictionException {
        return this.propagateNewLowerBound(this.coeffPolicy.computeLowerBound());
    }

    @Override
    public boolean filterOnImprovedUpperBound() throws ContradictionException {
        return this.propagateNewUpperBound(this.coeffPolicy.computeUpperBound());
    }

    @Override
    public boolean isConsistent() {
        return this.hasConsistentLowerBound() && this.hasConsistentUpperBound();
    }

    @Override
    public AbstractSConstraint opposite(Solver solver) {
        IntExp term = solver.scalar(this.coeffs, this.vars);
        return (AbstractSConstraint)solver.neq(term, -this.cste);
    }

    @Override
    protected String getOperator() {
        return " = ";
    }
}

