/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.Interval;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.ObjectiveFunction;
import org.jpmml.lightgbm.Section;

public class LightGBMUtil {
    private static final Pattern PATTERN_OBJECTIVE_FUNCTION = Pattern.compile("([^\\(]+)(?:\\((.*)\\))?");
    private static final Pattern PATTERN_UNICODE_ESCAPE = Pattern.compile("\\\\u([0-9A-Fa-f]{4})");

    private LightGBMUtil() {
    }

    public static GBDT loadGBDT(InputStream is) throws IOException {
        return LightGBMUtil.loadGBDT(LightGBMUtil.parseText(is));
    }

    public static GBDT loadGBDT(Iterator<String> lines) {
        List<Section> sections = LightGBMUtil.loadText(lines);
        GBDT gbdt = new GBDT();
        gbdt.load(sections);
        return gbdt;
    }

    private static List<Section> loadText(Iterator<String> lines) {
        ArrayList<Section> sections = new ArrayList<Section>();
        Section section = new Section();
        while (lines.hasNext()) {
            String line = lines.next();
            if ("".equals(line)) {
                if (section.size() <= 0) continue;
                sections.add(section);
                section = new Section();
                continue;
            }
            section.put(line);
        }
        if (section.size() > 0) {
            sections.add(section);
        }
        return sections;
    }

    public static Iterator<String> parseText(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, "US-ASCII");
        List lines = CharStreams.readLines((Readable)reader);
        return lines.iterator();
    }

    public static ObjectiveFunction parseObjectiveFunction(String string) {
        String[] tokens;
        Matcher matcher = PATTERN_OBJECTIVE_FUNCTION.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string);
        }
        String className = matcher.group(1);
        String args = matcher.group(2);
        Section config = new Section();
        if (args != null && args.trim().length() > 0 && (tokens = args.split("\\s+")).length > 0) {
            String name = tokens[0];
            config.put("name", name);
            for (int i = 1; i < tokens.length; ++i) {
                String token = tokens[i];
                config.put(token, ':');
            }
        }
        try {
            Class<ObjectiveFunction> clazz = Class.forName(className).asSubclass(ObjectiveFunction.class);
            Constructor<ObjectiveFunction> constructor = clazz.getDeclaredConstructor(Section.class);
            return constructor.newInstance(config);
        }
        catch (ReflectiveOperationException roe) {
            throw new IllegalArgumentException(string, roe);
        }
    }

    public static String[] parseStringArray(String string, int length) {
        String[] tokens = string.split(" ");
        if (length > -1 && tokens.length != length) {
            throw new IllegalArgumentException();
        }
        return tokens;
    }

    public static String[][] parseStringArrayList(String string, int[] lengths) {
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern pattern = Pattern.compile("([^ ]+)| ");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            tokens.add(matcher.group());
        }
        Iterator<String> it = tokens.iterator();
        String[][] result = new String[lengths.length][];
        for (int i = 0; i < lengths.length; ++i) {
            int length = lengths[i];
            result[i] = new String[length];
            if (length == 0) {
                LightGBMUtil.getSpace(it);
                continue;
            }
            for (int j = 0; j < length; ++j) {
                result[i][j] = LightGBMUtil.getToken(it);
                LightGBMUtil.getSpace(it);
            }
            LightGBMUtil.getSpace(it);
        }
        if (it.hasNext()) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private static String getSpace(Iterator<String> it) {
        String string = it.next();
        if (!" ".equals(string)) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    private static String getToken(Iterator<String> it) {
        String string = it.next();
        if (" ".equals(string)) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public static int[] parseIntArray(String string, int length) {
        String[] values = LightGBMUtil.parseStringArray(string, length);
        return LightGBMUtil.toIntArray(values);
    }

    public static int[][] parseIntArrayList(String string, int[] lengths) {
        String[][] values = LightGBMUtil.parseStringArrayList(string, lengths);
        int[][] result = new int[values.length][];
        for (int i = 0; i < values.length; ++i) {
            result[i] = LightGBMUtil.toIntArray(values[i]);
        }
        return result;
    }

    public static long[] parseUnsignedIntArray(String string, int length) {
        String[] values = LightGBMUtil.parseStringArray(string, length);
        return LightGBMUtil.toUnsignedIntArray(values);
    }

    public static double[] parseDoubleArray(String string, int length) {
        String[] values = LightGBMUtil.parseStringArray(string, length);
        return LightGBMUtil.toDoubleArray(values);
    }

    public static double[][] parseDoubleArrayList(String string, int[] lengths) {
        String[][] values = LightGBMUtil.parseStringArrayList(string, lengths);
        double[][] result = new double[values.length][];
        for (int i = 0; i < values.length; ++i) {
            result[i] = LightGBMUtil.toDoubleArray(values[i]);
        }
        return result;
    }

    public static boolean isNone(String string) {
        return string.equals("none");
    }

    public static boolean isInterval(String string) {
        return string.startsWith("[") && string.endsWith("]");
    }

    public static boolean isBinaryInterval(String string) {
        return string.equals("[0:1]");
    }

    public static boolean isValues(String string) {
        return !LightGBMUtil.isInterval(string);
    }

    public static Interval parseInterval(String string) {
        Interval.Closure closure;
        if (string.length() < 3) {
            throw new IllegalArgumentException(string);
        }
        String bounds = string.substring(0, 1) + string.substring(string.length() - 1, string.length());
        String margins = string.substring(1, string.length() - 1);
        switch (bounds) {
            case "[]": {
                closure = Interval.Closure.CLOSED_CLOSED;
                break;
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
        String[] values = margins.split(":");
        if (values.length != 2) {
            throw new IllegalArgumentException(margins);
        }
        Double leftMargin = null;
        if (!values[0].equalsIgnoreCase("-inf")) {
            leftMargin = Double.valueOf(values[0]);
        }
        Double rightMargin = null;
        if (!values[1].equalsIgnoreCase("inf")) {
            rightMargin = Double.valueOf(values[1]);
        }
        if (leftMargin == null && rightMargin == null) {
            return null;
        }
        return new Interval(closure, (Number)leftMargin, (Number)rightMargin);
    }

    public static List<Integer> parseValues(String string) {
        String[] values = string.split(":");
        return Stream.of(values).map(Integer::valueOf).collect(Collectors.toList());
    }

    public static String unescape(String string) {
        if (string == null || !string.contains("\\u")) {
            return string;
        }
        StringBuffer sb = new StringBuffer(string.length());
        Matcher matcher = PATTERN_UNICODE_ESCAPE.matcher(string);
        while (matcher.find()) {
            int c = Integer.parseInt(matcher.group(1), 16);
            matcher.appendReplacement(sb, Character.toString((char)c));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static int[] toIntArray(String[] values) {
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = LightGBMUtil.parseInt(values[i]);
        }
        return result;
    }

    private static long[] toUnsignedIntArray(String[] values) {
        long[] result = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = LightGBMUtil.parseUnsignedInt(values[i]);
        }
        return result;
    }

    private static double[] toDoubleArray(String[] values) {
        double[] result = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = LightGBMUtil.parseDouble(values[i]);
        }
        return result;
    }

    private static int parseInt(String string) {
        return Integer.parseInt(string);
    }

    private static long parseUnsignedInt(String string) {
        return Long.parseLong(string);
    }

    private static double parseDouble(String string) {
        switch (string) {
            case "inf": {
                return Double.POSITIVE_INFINITY;
            }
        }
        return Double.parseDouble(string);
    }
}

