## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(rio)
library(haven)

## -----------------------------------------------------------------------------
gender <- haven::labelled(
                     c("M", "F", "F", "F", "M"),
                     c(Male = "M", Female = "F"))

## -----------------------------------------------------------------------------
rating <- sample(1:5)
attr(rating, "labels") <-  c(c(Good = 1, Bad = 5))

## -----------------------------------------------------------------------------
mydata <- data.frame(gender, rating)

## -----------------------------------------------------------------------------
export(mydata, "mydata.sav")
restored_data <- rio::import("mydata.sav")
str(restored_data)

## -----------------------------------------------------------------------------
g <- rio::gather_attrs(restored_data)
str(g)
attr(g, "labels")

## ----include = FALSE----------------------------------------------------------
unlink("mydata.sav")

