/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdplus.sa.base.api.SaOutputFactory;

public final class SaOutputFactoryLoader {
    private static final Iterable<SaOutputFactory> SOURCE = ServiceLoader.load(SaOutputFactory.class);
    private static final AtomicReference<List<SaOutputFactory>> RESOURCE = new AtomicReference<List<SaOutputFactory>>(SaOutputFactoryLoader.doLoad());
    private static final Consumer<Iterable> CLEANER = loader -> ((ServiceLoader)loader).reload();

    private SaOutputFactoryLoader() {
    }

    private static List<SaOutputFactory> doLoad() {
        return StreamSupport.stream(SOURCE.spliterator(), false).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static List<SaOutputFactory> get() {
        return RESOURCE.get();
    }

    public static void set(List<SaOutputFactory> newValue) {
        RESOURCE.set(Objects.requireNonNull(newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        Iterable<SaOutputFactory> iterable = SOURCE;
        synchronized (iterable) {
            CLEANER.accept(SOURCE);
            SaOutputFactoryLoader.set(SaOutputFactoryLoader.doLoad());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Iterable<SaOutputFactory> iterable = SOURCE;
        synchronized (iterable) {
            SaOutputFactoryLoader.set(SaOutputFactoryLoader.doLoad());
        }
    }
}

