/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramo;

import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AutoModelSpec
implements Validatable<AutoModelSpec> {
    public static final AutoModelSpec DEFAULT_DISABLED = (AutoModelSpec)AutoModelSpec.builder().build();
    public static final AutoModelSpec DEFAULT_ENABLED = (AutoModelSpec)AutoModelSpec.builder().enabled(true).build();
    public static final double DEF_CANCEL = 0.05;
    public static final double DEF_PCR = 0.95;
    public static final double DEF_UB1 = 0.97;
    public static final double DEF_UB2 = 0.91;
    public static final double DEF_TSIG = 1.0;
    public static final double DEF_PC = 0.12;
    public static final boolean DEF_FAL = false;
    public static final boolean DEF_AMICOMPARE = false;
    private final double cancel;
    private final double ub1;
    private final double ub2;
    private final double pcr;
    private final double pc;
    private final double tsig;
    private final boolean enabled;
    private final boolean acceptDefault;
    private final boolean amiCompare;

    public static Builder builder() {
        return new Builder().cancel(0.05).ub1(0.97).ub2(0.91).pcr(0.95).pc(0.12).tsig(1.0).enabled(false).acceptDefault(false).amiCompare(false);
    }

    public AutoModelSpec validate() throws IllegalArgumentException {
        if (this.pcr < 0.8 || this.pcr > 1.0) {
            throw new IllegalArgumentException("PCR should belong to [0.8, 1.0]");
        }
        if (this.ub1 < 0.8 || this.ub1 > 1.0) {
            throw new IllegalArgumentException("UB1 should belong to [0.8, 1.0]");
        }
        if (this.ub2 < 0.8 || this.ub2 > 1.0) {
            throw new IllegalArgumentException("UB2 should belong to [0.8, 1.0]");
        }
        if (this.cancel < 0.0 || this.cancel > 0.3) {
            throw new IllegalArgumentException("Cancelation limit should belong to [0, 0.3]");
        }
        if (this.tsig <= 0.5) {
            throw new IllegalArgumentException("TSIG should be higher than 0.5");
        }
        if (this.pc < 0.1 || this.pc > 0.3) {
            throw new IllegalArgumentException("PC should belong to [0.1, 0.3]");
        }
        return this;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_ENABLED);
    }

    @Generated
    AutoModelSpec(double cancel, double ub1, double ub2, double pcr, double pc, double tsig, boolean enabled, boolean acceptDefault, boolean amiCompare) {
        this.cancel = cancel;
        this.ub1 = ub1;
        this.ub2 = ub2;
        this.pcr = pcr;
        this.pc = pc;
        this.tsig = tsig;
        this.enabled = enabled;
        this.acceptDefault = acceptDefault;
        this.amiCompare = amiCompare;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().cancel(this.cancel).ub1(this.ub1).ub2(this.ub2).pcr(this.pcr).pc(this.pc).tsig(this.tsig).enabled(this.enabled).acceptDefault(this.acceptDefault).amiCompare(this.amiCompare);
    }

    @Generated
    public double getCancel() {
        return this.cancel;
    }

    @Generated
    public double getUb1() {
        return this.ub1;
    }

    @Generated
    public double getUb2() {
        return this.ub2;
    }

    @Generated
    public double getPcr() {
        return this.pcr;
    }

    @Generated
    public double getPc() {
        return this.pc;
    }

    @Generated
    public double getTsig() {
        return this.tsig;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isAcceptDefault() {
        return this.acceptDefault;
    }

    @Generated
    public boolean isAmiCompare() {
        return this.amiCompare;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoModelSpec)) {
            return false;
        }
        AutoModelSpec other = (AutoModelSpec)o;
        if (Double.compare(this.getCancel(), other.getCancel()) != 0) {
            return false;
        }
        if (Double.compare(this.getUb1(), other.getUb1()) != 0) {
            return false;
        }
        if (Double.compare(this.getUb2(), other.getUb2()) != 0) {
            return false;
        }
        if (Double.compare(this.getPcr(), other.getPcr()) != 0) {
            return false;
        }
        if (Double.compare(this.getPc(), other.getPc()) != 0) {
            return false;
        }
        if (Double.compare(this.getTsig(), other.getTsig()) != 0) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isAcceptDefault() != other.isAcceptDefault()) {
            return false;
        }
        return this.isAmiCompare() == other.isAmiCompare();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $cancel = Double.doubleToLongBits(this.getCancel());
        result = result * 59 + (int)($cancel >>> 32 ^ $cancel);
        long $ub1 = Double.doubleToLongBits(this.getUb1());
        result = result * 59 + (int)($ub1 >>> 32 ^ $ub1);
        long $ub2 = Double.doubleToLongBits(this.getUb2());
        result = result * 59 + (int)($ub2 >>> 32 ^ $ub2);
        long $pcr = Double.doubleToLongBits(this.getPcr());
        result = result * 59 + (int)($pcr >>> 32 ^ $pcr);
        long $pc = Double.doubleToLongBits(this.getPc());
        result = result * 59 + (int)($pc >>> 32 ^ $pc);
        long $tsig = Double.doubleToLongBits(this.getTsig());
        result = result * 59 + (int)($tsig >>> 32 ^ $tsig);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isAcceptDefault() ? 79 : 97);
        result = result * 59 + (this.isAmiCompare() ? 79 : 97);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "AutoModelSpec(cancel=" + this.getCancel() + ", ub1=" + this.getUb1() + ", ub2=" + this.getUb2() + ", pcr=" + this.getPcr() + ", pc=" + this.getPc() + ", tsig=" + this.getTsig() + ", enabled=" + this.isEnabled() + ", acceptDefault=" + this.isAcceptDefault() + ", amiCompare=" + this.isAmiCompare() + ")";
    }

    public static class Builder
    implements Validatable.Builder<AutoModelSpec> {
        @Generated
        private double cancel;
        @Generated
        private double ub1;
        @Generated
        private double ub2;
        @Generated
        private double pcr;
        @Generated
        private double pc;
        @Generated
        private double tsig;
        @Generated
        private boolean enabled;
        @Generated
        private boolean acceptDefault;
        @Generated
        private boolean amiCompare;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder cancel(double cancel) {
            this.cancel = cancel;
            return this;
        }

        @Generated
        public @NonNull Builder ub1(double ub1) {
            this.ub1 = ub1;
            return this;
        }

        @Generated
        public @NonNull Builder ub2(double ub2) {
            this.ub2 = ub2;
            return this;
        }

        @Generated
        public @NonNull Builder pcr(double pcr) {
            this.pcr = pcr;
            return this;
        }

        @Generated
        public @NonNull Builder pc(double pc) {
            this.pc = pc;
            return this;
        }

        @Generated
        public @NonNull Builder tsig(double tsig) {
            this.tsig = tsig;
            return this;
        }

        @Generated
        public @NonNull Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public @NonNull Builder acceptDefault(boolean acceptDefault) {
            this.acceptDefault = acceptDefault;
            return this;
        }

        @Generated
        public @NonNull Builder amiCompare(boolean amiCompare) {
            this.amiCompare = amiCompare;
            return this;
        }

        @Generated
        public @NonNull AutoModelSpec buildWithoutValidation() {
            return new AutoModelSpec(this.cancel, this.ub1, this.ub2, this.pcr, this.pc, this.tsig, this.enabled, this.acceptDefault, this.amiCompare);
        }

        @Generated
        public @NonNull String toString() {
            return "AutoModelSpec.Builder(cancel=" + this.cancel + ", ub1=" + this.ub1 + ", ub2=" + this.ub2 + ", pcr=" + this.pcr + ", pc=" + this.pc + ", tsig=" + this.tsig + ", enabled=" + this.enabled + ", acceptDefault=" + this.acceptDefault + ", amiCompare=" + this.amiCompare + ")";
        }
    }
}

