% File src/library/base/man/vector.Rd
% Part of the R package, https://www.R-project.org
% Copyright 1995-2021 R Core Team
% Distributed under GPL 2 or later

\name{vector}
\title{Vectors - Creation, Coercion, etc}
\alias{vector}
\alias{as.vector}
\alias{as.vector.data.frame}
\alias{as.vector.factor}
\alias{as.vector.POSIXlt}
\alias{is.vector}
\alias{atomic} % for cat.Rd and read.table.Rd
\usage{
vector(mode = "logical", length = 0)
as.vector(x, mode = "any")
is.vector(x, mode = "any")
}
\arguments{
  \item{mode}{character string naming an atomic mode or
    \code{"list"} or \code{"expression"} or (except for \code{vector})
    \code{"any"}.  Currently, \code{is.vector()} allows any type (see
    \code{\link{typeof}}) for \code{mode}, and when mode is not
    \code{"any"}, \code{is.vector(x, mode)} is almost the same as
    \code{typeof(x) == mode}.}% differences: for mode = NA, or mode = "numeric"
  \item{length}{a non-negative integer specifying the desired length.  For
    a \link{long vector}, i.e., \code{length > .Machine$integer.max}, it
    has to be of type \code{"double"}.  Supplying an argument of length
    other than one is an error.}
  \item{x}{an \R object.}
}
\description{
  A \emph{vector} in \R is either an atomic vector i.e., one of the atomic
  types, see \sQuote{Details}, or of type (\code{\link{typeof}}) or mode
  \code{\link{list}} or \code{\link{expression}}.

  \code{vector} produces a \sQuote{simple} vector of the given length and
  mode, where a \sQuote{simple} vector has no attribute, i.e., fulfills
  \code{is.null(\link{attributes}(.))}.

  \code{as.vector}, a generic, attempts to coerce its argument into a
  vector of mode \code{mode} (the default is to coerce to whichever
  vector mode is most convenient): if the result is atomic
  (\code{\link{is.atomic}}), all attributes are removed.
  For \code{mode="any"}, see \sQuote{Details}.

  \code{is.vector(x)} returns \code{TRUE} if \code{x} is a vector of the
  specified mode having no attributes \emph{other than names}.
  For \code{mode="any"}, see \sQuote{Details}.
  % It returns \code{FALSE} otherwise.
}

\details{
  The atomic modes are \code{"logical"}, \code{"integer"},
  \code{"numeric"} (synonym \code{"double"}), \code{"complex"},
  \code{"character"} and \code{"raw"}.

  If \code{mode = "any"}, \code{is.vector} may return \code{TRUE} for
  the atomic modes, \code{\link{list}} and \code{\link{expression}}.
  For any \code{mode}, it will return \code{FALSE} if \code{x} has any
  attributes except names.  (This is incompatible with S.)  On the other
  hand, \code{as.vector} removes \emph{all} attributes including names
  for results of atomic mode.

  For \code{mode = "any"}, and atomic vectors \code{x}, \code{as.vector(x)}
  strips all \code{\link{attributes}} (including \code{\link{names}}),
  returning a simple atomic vector. \cr
  However, when \code{x} is of type \code{"\link{list}"} or
  \code{"\link{expression}"}, \code{as.vector(x)} currently returns the
  argument \code{x} unchanged, unless there is an \code{as.vector} method
  for \code{\link{class}(x)}.

  Note that factors are \emph{not} vectors; \code{is.vector} returns
  \code{FALSE} and \code{as.vector} converts a factor to a character
  vector for \code{mode = "any"}.
}

\value{
  For \code{vector}, a vector of the given length and mode.  Logical
  vector elements are initialized to \code{FALSE}, numeric vector
  elements to \code{0}, character vector elements to \code{""}, raw
  vector elements to \code{nul} bytes and list/expression elements to
  \code{NULL}.

  For \code{as.vector}, a vector (atomic or of type list or expression).
  All attributes are removed from the result if it is of an atomic mode,
  but not in general for a list or expression result.  The default method handles 24
  input types and 12 values of \code{type}: the details of most
  coercions are undocumented and subject to change.

  For \code{is.vector}, \code{TRUE} or \code{FALSE}.
  \code{is.vector(x, mode = "numeric")} can be true for vectors of types
  \code{"integer"} or \code{"double"} whereas \code{is.vector(x, mode =
  "double")} can only be true for those of type \code{"double"}.
}

\section{Methods for \code{as.vector()}}{
  Writers of methods for \code{as.vector} need to take care to
  follow the conventions of the default method.  In particular
  \itemize{
    \item Argument \code{mode} can be \code{"any"}, any of the atomic
    modes, \code{"list"}, \code{"expression"}, \code{"symbol"},
    \code{"pairlist"} or one of the aliases \code{"double"} and \code{"name"}.

    \item The return value should be of the appropriate mode.  For
    \code{mode = "any"} this means an atomic vector or list or expression.

    \item Attributes should be treated appropriately: in particular when
    the result is an atomic vector there should be no attributes, not
    even names.

    \item \code{is.vector(as.vector(x, m), m)} should be true for any
    mode \code{m}, including the default \code{"any"}.

    Currently this is not fulfilled in \R when \code{m == "any"} and
    \code{x} is of type \code{\link{list}} or \code{\link{expression}} with
    attributes in addition to \code{\link{names}} --- typically the case for
    (S3 or S4) objects (see \code{\link{is.object}}) which are lists
    internally.
  }
}

\note{
  \code{as.vector} and \code{is.vector} are quite distinct from the
  meaning of the formal class \code{"vector"} in the \pkg{methods}
  package, and hence \code{\link{as}(x, "vector")} and
  \code{\link{is}(x, "vector")}.

  Note that \code{as.vector(x)} is not necessarily a null operation if
  \code{is.vector(x)} is true: any names will be removed from an atomic
  vector. % This is considered a blemish; using `unname0(x)`
  % would rather be recommended:  unname0 <- \(x) `names<-`(x, NULL)

  Non-vector \code{mode}s \code{"symbol"} (synonym \code{"name"}) and
  \code{"pairlist"} are accepted but have long been undocumented: they
  are used to implement \code{\link{as.name}} and
  \code{\link{as.pairlist}}, and those functions should preferably be
  used directly.  None of the description here applies to those
  \code{mode}s: see the help for the preferred forms.
}

\references{
  \bibshow{R:Becker+Chambers+Wilks:1988}
}
\seealso{
  \code{\link{c}}, \code{\link{is.numeric}}, \code{\link{is.list}}, etc.
}
\examples{
df <- data.frame(x = 1:3, y = 5:7)
## Error:
try(as.vector(data.frame(x = 1:3, y = 5:7), mode = "numeric"))

x <- c(a = 1, b = 2)
is.vector(x)
as.vector(x)
all.equal(x, as.vector(x)) ## FALSE


###-- All the following are TRUE:
is.list(df)
! is.vector(df)
! is.vector(df, mode = "list")

is.vector(list(), mode = "list")
}
\keyword{classes}
