% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cond_histo.r
\name{plot_cond_histo}
\alias{plot_cond_histo}
\title{plot_cond_histo function}
\usage{
plot_cond_histo(
  variable = NULL,
  horizon = 1,
  threshold = NULL,
  data = NULL,
  above = TRUE,
  size = 5
)
}
\arguments{
\item{variable}{(character) Name of variable to be plotted}

\item{horizon}{(numeric) At which horizon (horizon<=h)}

\item{threshold}{(numeric,optional) If present compute P(x>threshold)}

\item{data}{data of conditional forecasts}

\item{above}{(logical,optional): if TRUE then compute probability above threshold}

\item{size}{(optional) size of annotation text in the plot}
}
\value{
ggplot object (plot)
}
\description{
This function uses the conditional probability calculations (eg scenarios) and plots the histogram of the selected variable
}
\examples{
# Example with simulated conditional forecast data
# Create sample forecast data matrix
set.seed(123)
n_sims <- 500
horizons <- 3
variables <- c("GDP", "CPI", "FFR")

# Create column names in the expected format (variable.horizon)
col_names <- outer(variables, 1:horizons, paste, sep = ".")

# Generate random forecast data
forecast_data <- matrix(rnorm(n_sims * length(col_names)), 
                       nrow = n_sims, ncol = length(col_names))
colnames(forecast_data) <- as.vector(col_names)

# Plot histogram for GDP at horizon 2
p <- plot_cond_histo(data = t(forecast_data), 
                     variable = "GDP", 
                     horizon = 2,
                     threshold = 0.5, 
                     above = TRUE)

}
