% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{boxplots.as_data}
\alias{boxplots.as_data}
\title{Boxplots}
\usage{
\method{boxplots}{as_data}(
  data_object,
  main = "Boxplot Comparison",
  labels = NULL,
  test = TRUE,
  predictions = NULL,
  by_families = FALSE,
  color_list = NULL,
  ml_color = NULL,
  ordered_option_names = NULL,
  xlab = "Strategy",
  ylab = "KPI",
  ...
)
}
\arguments{
\item{data_object}{object of class \code{as_data}.}

\item{main}{an overall title for the plot.}

\item{labels}{character vector with the labels for each of the algorithms. If NULL, the y names of the \code{data_object} names will be used.}

\item{test}{flag that indicates whether the function should use test data or training data.}

\item{predictions}{a data frame with the predicted KPI for each algorithm (columns) and for each instance (rows). If NULL, the plot won't include a ML column.}

\item{by_families}{boolean indicating whether the function should represent data by families or not. The family information must be included in the \code{data_object} parameter.}

\item{color_list}{list with the colors for the plots. If NULL, or insufficient number of colors, the colors will be generated automatically.}

\item{ml_color}{color por the ML boxplot. If NULL, it will be generated automatically.}

\item{ordered_option_names}{vector with the name of the columns of \code{data_object} y variable in the correct order.}

\item{xlab}{a label for the x axis.}

\item{ylab}{a label for the y axis.}

\item{...}{other parameters.}
}
\value{
A \code{ggplot} object representing the boxplots of instance-normalized KPI for each algorithm across instances.
}
\description{
Represents a boxplot for each of the algorithms to compare their performance according to the response variable (KPI). When available, it also includes a box plot for the "ML" algorithm generated from the predictions.
}
\examples{
data(branchingsmall)
data <- partition_and_normalize(branchingsmall$x, branchingsmall$y)
training <- AStrain(data, method = "glm")
predict_test <- ASpredict(training, newdata = data$x.test)
boxplots(data, predictions = predict_test)
}
