% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HolmTest.R
\name{HolmTest}
\alias{HolmTest}
\title{Holm-Adjusted Pairwise Comparisons}
\usage{
HolmTest(modelo, alpha = 0.05)
}
\arguments{
\item{modelo}{An object of class \code{aov} or \code{lm}.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"holm"} and \code{"comparaciones"}, containing:
\itemize{
  \item \code{Resultados}: Data frame of comparisons, mean differences, t-values, unadjusted and adjusted p-values, and significance codes.
  \item \code{Promedios}: Named numeric vector of group means.
  \item \code{Orden_Medias}: Character vector with group names ordered from highest to lowest mean.
  \item \code{Metodo}: Name of the method used ("Holm-adjusted t-test").
}
}
\description{
Performs pairwise t-tests with p-values adjusted using Holm’s sequential method.
}
\details{
Advantages:
- Controls family-wise error rate more efficiently than Bonferroni.
- Easy to apply over any set of p-values.

Disadvantages:
- Does not adjust test statistics, only p-values.
- Slightly more conservative than false discovery rate (FDR) methods.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- HolmTest(mod)
summary(resultado)
plot(resultado)


}
\references{
Holm, S. (1979). A simple sequentially rejective multiple test procedure.
\emph{Scandinavian Journal of Statistics}, 6(2), 65–70.
}
