% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_emp_bayes.R
\name{AM_emp_bayes_uninorm}
\alias{AM_emp_bayes_uninorm}
\title{compute the hyperparameters of an Normal-Inverse-Gamma distribution using an empirical Bayes approach}
\usage{
AM_emp_bayes_uninorm(y, scEmu = 1, scEsig2 = 3, CVsig2 = 3)
}
\arguments{
\item{y}{The data y. If y is univariate, a vector is expected. Otherwise, y should be a matrix.}

\item{scEmu}{a positive value (default=1) such that marginally E(\eqn{\mu}) = \eqn{s^2}*scEmu, where \eqn{s^2} is the
sample variance.}

\item{scEsig2}{a positive value (default=3) such that marginally E(\eqn{\sigma^2}) = \eqn{s^2}*scEsig2, where \eqn{s^2} is the
sample variance.}

\item{CVsig2}{The coefficient of variation of \eqn{\sigma^2} (default=3).}
}
\value{
an object of class \code{\link{AM_mix_hyperparams}}, in which hyperparameters \code{m0}, \code{k0},
\code{nu0} and \code{sig02} are specified. To understand the usage of these hyperparameters, please refer to
\code{\link{AM_mix_hyperparams_uninorm}}.
}
\description{
This function computes the hyperparameters of a Normal Inverse-Gamma distribution using an empirical Bayes approach.
More information about how these hyperparameters are determined can be found here:
\emph{Bayes and empirical Bayes: do they merge?} \insertCite{petrone2012bayes}{AntMAN}.
}
