% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{delete_kusto_cluster}
\alias{delete_kusto_cluster}
\alias{delete_kusto_cluster,}
\alias{delete_azure_data_explorer}
\title{Delete Kusto/Azure Data Explorer cluster}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{delete_kusto_cluster(name, confirm=TRUE, wait=FALSE)
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the cluster.
\item \code{confirm}: Whether to ask for confirmation before deleting.
\item \code{wait}: Whether to wait until the deletion is complete.
}
}

\section{Value}{

NULL on successful deletion.
}

\examples{
\dontrun{

rg <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# delete a Kusto cluster
rg$delete_kusto_cluster("mycluster")

}
}
\seealso{
\link{create_kusto_cluster}, \link{get_kusto_cluster}, \link{az_kusto}

\href{https://learn.microsoft.com/en-us/azure/data-explorer/}{Kusto/Azure Data Explorer documentation}
}
