% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_reb_off_success.R
\name{do_reb_off_success}
\alias{do_reb_off_success}
\title{Check if scoring after offensive rebounds}
\usage{
do_reb_off_success(data, day_num, game_code, team_sel, verbose)
}
\arguments{
\item{data}{Play-by-play prepared data from a given game.}

\item{day_num}{Day number.}

\item{game_code}{Game code.}

\item{team_sel}{One of the teams' names involved in the game.}

\item{verbose}{Logical. Decide if information of the computations
must be provided or not.}
}
\value{
List with two data frames, one for the results for the team (\strong{stats_team}) 
and the other for the players (\strong{stats_player}).
The team data frame shows the number of offensive rebounds, the number of those
that finished in scoring (and the percentage associated) and the total of points 
scored.
The player data frame shows the player who grabbed the offensive rebound, the 
player who scored and how many points.
}
\description{
For each team and player, locate the position of offensive rebounds 
and check if they resulted in scoring points.
}
\examples{
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

df1 <- do_prepare_data_or(df0, TRUE, acb_games_2223_info)

df2 <- do_reb_off_success(df1, day_num, game_code, "Valencia Basket", FALSE)
#df2                        

}
\seealso{
\code{\link{do_prepare_data_or}}
}
\author{
Guillermo Vinue
}
