% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmiselect.R
\name{BMI_LASSO}
\alias{BMI_LASSO}
\title{Bayesian MI-LASSO for Multiply-Imputed Regression}
\usage{
BMI_LASSO(
  X,
  Y,
  model,
  standardize = TRUE,
  SNC = TRUE,
  grid = seq(0, 1, 0.01),
  orthogonal = FALSE,
  nburn = 4000,
  npost = 4000,
  seed = NULL,
  nchain = 1,
  ncores = 1,
  verbose = TRUE,
  printevery = 1000,
  ...
)
}
\arguments{
\item{X}{A numeric matrix or array of predictors.  If a matrix \code{n × p},
it is taken as one imputation; if an array \code{D × n × p}, each slice
along the first dimension is one imputed dataset.}

\item{Y}{A numeric vector or matrix of outcomes.  If a vector of length \code{n},
it is recycled for each imputation; if a \code{D × n} matrix, each row
is the response for one imputation.}

\item{model}{Character; which prior to use.  One of \code{"Multi_Laplace"},
\code{"Horseshoe"}, \code{"ARD"}, or \code{"Spike_Laplace"}.}

\item{standardize}{Logical; whether to normalize each \code{X} and centralize
\code{Y} within each imputation before fitting.  Default \code{TRUE}.}

\item{SNC}{Logical; if \code{TRUE}, use scaled neighborhood criterion;
otherwise apply thresholding or median‐based selection. Default \code{TRUE}.}

\item{grid}{Numeric vector; grid of scaled neighborhood criterion (or thresholding) to explore.
Default \code{seq(0,1,0.01)}.}

\item{orthogonal}{Logical; if \code{TRUE}, using orthogonal approximations for
degrees‐of‐freedom estimations.  Default \code{FALSE}.}

\item{nburn}{Integer; number of burn-in MCMC iterations per chain. Default \code{4000}.}

\item{npost}{Integer; number of post-burn-in samples to retain per chain. Default \code{4000}.}

\item{seed}{Optional integer; base random seed.  Each chain adds its index.}

\item{nchain}{Integer; number of MCMC chains to run in parallel. Default \code{1}.}

\item{ncores}{Integer; number of parallel cores to use. Default \code{1}.}

\item{verbose}{Logical; print progress messages. Default \code{TRUE}.}

\item{printevery}{Integer; print status every so many iterations. Default \code{1000}.}

\item{\dots}{Additional model-specific hyperparameters:
\itemize{
\item For \code{"Multi_Laplace"}: \code{h} (shape) and \code{v} (scale) of Gamma hyperprior.
\item For \code{"Spike_Laplace"}: \code{a} (shape) and \code{b} (scale) of Gamma hyperprior.
}}
}
\value{
A named list with elements:
\describe{
\item{\code{posterior}}{List of length \code{nchain} of MCMC outputs (posterior draws).}
\item{\code{select}}{List of length \code{nchain} of logical matrices showing
which variables are selected at each grid value.}
\item{\code{best_select}}{List of length \code{nchain} of the single best
selection (by BIC) for each chain.}
\item{\code{posterior_best_models}}{List of length \code{nchain} of projected
posterior draws for the best submodel.}
\item{\code{bic_models}}{List of length \code{nchain} of BIC values and
degrees-of-freedom for each candidate submodel.}
\item{\code{summary_table_full}}{A data frame summarizing rank-normalized
split-Rhat and other diagnostics for the full model.}
\item{\code{summary_table_selected}}{A data frame summarizing diagnostics
for the selected submodel after projection.}
}
}
\description{
Fit a Bayesian multiple-imputation LASSO (BMI-LASSO) model across
multiply-imputed datasets, using one of four priors: Multi-Laplace,
Horseshoe, ARD, or Spike-Laplace. Automatically standardizes data,
runs MCMC in parallel, performs variable selection via three-step
projection predictive variable selection, and selects a final submodel by BIC.
}
\examples{
sim <- sim_A(n = 100, p = 20, type = "MAR", SNP = 1.5, low_missing = TRUE, n_imp = 5, seed = 123)
X <- sim$data_MI$X
Y <- sim$data_MI$Y
fit <- BMI_LASSO(X, Y, model = "Horseshoe",
                 nburn = 100, npost = 100,
                 nchain = 1, ncores = 1)
str(fit$best_select)
}
