% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixPY2.R
\name{MixPY2}
\alias{MixPY2}
\title{Pitman-Yor process mixture  of Type II}
\usage{
MixPY2(
  x,
  probs = c(0.025, 0.5, 0.975),
  Alpha = 1,
  Gama = 0.4,
  asigma = 2,
  bsigma = 1/var(x),
  Nx = 100,
  Nit = 1500,
  Pbi = 0.5,
  epsilon = NULL,
  printtime = TRUE,
  extras = TRUE
)
}
\arguments{
\item{x}{Numeric vector. Data set to which the density is fitted.}

\item{probs}{Numeric vector. Desired quantiles of the density estimates.}

\item{Alpha}{Numeric constant. Total mass of the centering measure. See}

\item{Gama}{Numeric constant. \eqn{0\leq \texttt{Gama} \leq 1}{0 <= Gama <=
1}.  See details.}

\item{asigma}{Numeric positive constant. Shape parameter of the gamma prior
on the standard deviation of the mixture kernel. Default value suggested by package BNPmix.}

\item{bsigma}{Numeric positive constant. Rate parameter of the gamma prior
on the standard deviation of the mixture kernel. Default value suggested by package BNPmix.}

\item{Nx}{Integer constant. Number of grid points for the evaluation of the
density estimate.}

\item{Nit}{Integer constant. Number of MCMC iterations.}

\item{Pbi}{Numeric constant. Burn-in period proportion of Nit.}

\item{epsilon}{Numeric constant. Extension to the evaluation grid range.
See details.}

\item{printtime}{Logical. If TRUE, prints out the execution time.}

\item{extras}{Logical. If TRUE, gives additional objects: means and weights}
}
\value{
The function returns a MixPY2 object. It is based on a list with the following components:
\item{xx}{Numeric vector. Evaluation grid.}
\item{qx}{Numeric array. Matrix
of dimension \eqn{\texttt{Nx} \times (\texttt{length(probs)} + 1)}{Nx x
(length(probs)+1)} with the posterior mean and the desired quantiles input
in \code{probs}.}
\item{R}{Numeric vector of
\code{length(Nit*(1-Pbi))} with the number of mixtures components
(clusters).}
\item{Allocs}{List of \code{length(Nit*(1-Pbi))} with the clustering
allocations.}
\item{means}{List of \code{length(Nit*(1-Pbi))} with the
cluster means (locations). Only if extras = TRUE.}
\item{sigmas}{List of \code{length(Nit*(1-Pbi))} with the
cluster standard deviations (scales). Only if extras = TRUE.}
\item{weights}{List of
\code{length(Nit*(1-Pbi))} with the mixture weights. Only if extras = TRUE.}
\item{Nit}{Integer constant. Number of MCMC iterations.}
\item{Pbi}{Numeric constant. Burn-in period proportion of \code{Nit}.}
\item{distr.k}{Integer corresponding to the kernel chosen for the mixture. Always 1, since the Pitman-Yor process is only written to work with Gaussian kernels.}
\item{data}{Data used for the fit}
\item{PY_params}{A named list with the parameters of the Pitman-Yor process}
}
\description{
This function calls the PYdensity function from package BNPmix, to allow fitting a Pitman-Yor process mixture to the data.
}
\examples{
# Data
data(acidity)
x <- acidity
# Fitting the model under default specifications
out <- MixPY2(x)
# Plotting density estimate + 95\% credible interval
plot(out)
}
