% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brvm-get.R
\name{BRVM_get}
\alias{BRVM_get}
\title{BRVM Get - Get Ticker Data}
\usage{
BRVM_get(.symbol, .from = Sys.Date() - 365, .to = Sys.Date() - 1)
}
\arguments{
\item{.symbol}{A vector of symbols, like: c("BICC","XOM","SlbC")}

\item{.from}{A quoted start date, ie. "2020-01-01" or "2020/01/01". The date
must be in ymd format "YYYY-MM-DD" or "YYYY/MM/DD".}

\item{.to}{A quoted end date, ie. "2022-01-31" or "2022/01/31". The date must
be in ymd format "YYYY-MM-DD" or "YYYY/MM/DD"}
}
\value{
A tibble
}
\description{
This function will get data from the Rich Bourse exchange.
}
\details{
This function will get data of the companies listed on the BVRM exchange through the Rich Bourse site. The function
takes in a single parameter of \code{.symbol} The function will auto-format the
tickers you input into all upper case by using \code{toupper()} The function will
next make sure that the ticker passed is inside of a google spreadsheet of
allowed tickers.
}
\examples{
\donttest{
library(lubridate)
library(rlang)
library(httr2)
library(dplyr)
library(stringr)

symbols <- c("BiCc","XOM","SlbC")
data_tbl <- BRVM_get(.symbol = symbols)
data_tbl
}

}
\seealso{
\url{https://www.richbourse.com}

\code{BRVM_ticker_desc()}, \code{BRVM_tickers()}

Other Data Retrieval: 
\code{\link{BRVM_bySector}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_rank}()},
\code{\link{BRVM_get1}()},
\code{\link{BRVM_index_stock}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_stock_market}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_nbrank}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()}

Other Richbourse: 
\code{\link{BRVM_ticker_desc}()}
}
\author{
Koffi Frederic SESSIE

Oudouss Diakité Abdoul

Steven P. Sanderson II, MPH
}
\concept{Data Retrieval}
\concept{Richbourse}
