% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PbPmanipulation.R
\name{PbPmanipulation}
\alias{PbPmanipulation}
\title{Adapts the standard file supplied by BigDataBall to the format required by BasketballAnalyzeR}
\usage{
PbPmanipulation(data, period.length = 12, overtime.length = 5)
}
\arguments{
\item{data}{a play-by-play  data frame supplied by BigDataBall (www.bigdataball.com).}

\item{period.length}{numeric, the length of a quarter in minutes (default: 12 minutes as in NBA)}

\item{overtime.length}{numeric, the length of an overtime period in minutes (default: 5 minutes as in NBA)}
}
\value{
A play-by-play data frame.

The data frame generated by \code{PbPmanipulation} has the same variables of \code{PbP.BDB} (when necessary, coerced from one data type to another, e.g from factor to numeric) plus the following five additional variables:

\itemize{
\item \code{periodTime}, time played in the quarter (in seconds)
}

\itemize{
\item \code{totalTime}, time played in the match (in seconds)
}

\itemize{
\item \code{playlength}, time since the immediately preceding event (in seconds)
}

\itemize{
\item \code{ShotType}, type of shot (FT, 2P, 3P)
}

\itemize{
\item \code{oppTeam}, name of the opponent team
}

\itemize{
\item \code{hometeam}, name of the home team (generated conditionally on  the presence of the variable \code{home_score})
}
}
\description{
Adapts the standard file supplied by BigDataBall to the format required by BasketballAnalyzeR
}
\examples{
PbP <- PbPmanipulation(PbP.BDB)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{PbP.BDB}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
