% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoredifference.R
\name{scoredifference}
\alias{scoredifference}
\title{Computes the score difference between the two teams in the match}
\usage{
scoredifference(PbP_data, team_name, player_data, team_data)
}
\arguments{
\item{PbP_data}{a play-by-play data frame, previously handled by \code{PbPmanipulation}}

\item{team_name}{name of the team we are interested in. The name can be either shortened (e.g. CLE) or extended (e.g. Cleveland Cavaliers)}

\item{player_data}{dataframe containing the boxscore data of all players of a particula season. We need it to know the players who have played at least one match for a team during the season. This dataframe might be substituted by a dataframe which has a column \code{Player} containing in each row the name of the players and a second columd \code{Team} containing the extended name (e.g. Golden State Warriors) of the team in which the player has played at least one match. If a player has played at least one match for more than one team during the same season, he/she will have a row for each franchise where has played}

\item{team_data}{dataframe, contains several data regarding the teams in the NBA. Inside this function it is used only to check if \code{team_name} corresponds to a team in the NBA. If the teams in the play-by-play data studied are the same as in the 2017-18 season, \code{Tadd} (the dataframe contained in the \code{BasketballAnalyzeR} package, regarding the 2017-18 season) can be used}
}
\value{
the initial play-by-play dataframe, with two additional columns:

\itemize{
\item \code{score.diff}: difference between the score of \code{team_name} and the score of the opposite team (see \code{details} for more informations)
}

*\code{isHome}: boolean which indicates if \code{team_name} is the home team in that play-by-play row
}
\description{
Computes the score difference between the two teams in the match
}
\details{
The score difference computed by the function can be different from the simple difference between the score of the home team and the one of the away team, as we have to take account of the points scored during an action. Indeed, the value of \code{score.diff} indicates the difference in the score while the action was played
}
\examples{
\dontrun{
  PbP <- PbPmanipulation(PbP.BDB)
  PbP <- scoredifference(PbP, team_name="GSW", player_data=Pbox, team_data=Tadd)
}
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.

P. Zuccolotto, M. Manisera and M. Sandri (2018) Big data analytics for modeling scoring probability in basketball: The effect of shooting under high pressure conditions. International Journal of Sports Science & Coaching.
}
\author{
Andrea Fox
}
