% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors-density.R
\name{density.prior}
\alias{density.prior}
\title{Prior density}
\usage{
\method{density}{prior}(
  x,
  x_seq = NULL,
  x_range = NULL,
  x_range_quant = NULL,
  n_points = 1000,
  n_samples = 10000,
  force_samples = FALSE,
  individual = FALSE,
  transformation = NULL,
  transformation_arguments = NULL,
  transformation_settings = FALSE,
  truncate_end = TRUE,
  ...
)
}
\arguments{
\item{x}{a prior}

\item{x_seq}{sequence of x coordinates}

\item{x_range}{vector of length two with
lower and upper range for the support
(used if \code{x_seq} is unspecified)}

\item{x_range_quant}{quantile used for
automatically obtaining \code{x_range}
if both \code{x_range} and \code{x_seq}
are unspecified. Defaults to \code{0.005}
for all but Cauchy, Student-t, Gamma, and
Inverse-gamme distributions that use
\code{0.010}.}

\item{n_points}{number of equally spaced points
in the \code{x_range} if \code{x_seq} is unspecified}

\item{n_samples}{number of samples from the prior
distribution if the density cannot be obtained
analytically (or if samples are forced with
\code{force_samples = TRUE})}

\item{force_samples}{should prior be sampled instead
of obtaining analytic solution whenever possible}

\item{individual}{should individual densities be returned
(e.g., in case of weightfunction)}

\item{transformation}{transformation to be applied
to the prior distribution. Either a character
specifying one of the prepared transformations:
\describe{
\item{lin}{linear transformation in form of \code{a + b*x}}
\item{tanh}{also known as Fisher's z transformation}
\item{exp}{exponential transformation}
}, or a list containing the transformation function \code{fun},
inverse transformation function \code{inv}, and the Jacobian of
the transformation \code{jac}. See examples for details.}

\item{transformation_arguments}{a list with named arguments for
the \code{transformation}}

\item{transformation_settings}{boolean indicating whether the
settings the \code{x_seq} or \code{x_range} was specified on
the transformed support}

\item{truncate_end}{whether the density should be set to zero in
for the endpoints of truncated distributions}

\item{...}{additional arguments}
}
\value{
\code{density.prior} returns an object of class 'density'.
}
\description{
Computes density of a prior
distribution across a range of values.
}
\seealso{
\code{\link[=prior]{prior()}}
}
