% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesGLM2.R
\name{BayesGLM2}
\alias{BayesGLM2}
\title{Group-level Bayesian GLM}
\usage{
BayesGLM2(
  results,
  contrasts = NULL,
  quantiles = NULL,
  excursion_type = NULL,
  contrast_names = NULL,
  gamma = 0,
  alpha = 0.05,
  nsamp_theta = 50,
  nsamp_beta = 100,
  num_cores = NULL,
  verbose = 1
)
}
\arguments{
\item{results}{Either (1) a length \eqn{N} list of \code{"BGLM"} objects,
or (2) a length \eqn{N} character vector of files storing \code{"BGLM"}
objects saved with \code{\link{saveRDS}}. \code{"fit_bglm"} objects
also are accepted.}

\item{contrasts}{(Optional) A list of contrast vectors that specify the
group-level summaries of interest. If \code{NULL} (DEFAULT), use contrasts that
compute the average of each field (field HRF) across all subjects/sessions.

Each contrast vector is length \eqn{KSN} specifying a group-level summary of
interest, where \eqn{K} is the number of fields in the first-level design
matrices, \eqn{S} is the number of sessions, and \eqn{N} is the number of
subjects. The vector is grouped by fields, then sessions, then subjects.

For a single session/subject, the contrast vector for the first field would be:

\code{c0 <- c(1, rep(0, K-1)) #indexes the first field for a single session}

so the full contrast vector for the group \emph{average over all sessions/subjects
for the first field} would be:

\code{contrasts = rep(c0, S*N) /(S*N)}.

To obtain the group average for the first field, for \emph{just the first session},
input zeros for the remaining sessions:

\code{c2 <- c(c0, rep(0, K*(S-1)))}
\code{contrasts = rep(c2, N) /N}.

To obtain the group mean \emph{difference between two sessions} (\eqn{S=2}) for the first field:

\code{c3 <- c(c0, -c0)}
\code{contrasts = rep(c3, N) / N}.

To obtain the \emph{mean over sessions} of the first field, just for the first subject:

\code{c4 <- rep(c0, S)}
\code{c(c4, rep(0, K*S*(N-1))) / S}.}

\item{quantiles}{(Optional) Vector of posterior quantiles to return in
addition to the posterior mean.}

\item{excursion_type}{(For inference only) The type of excursion function for
the contrast (">", "<", "!="), or a vector thereof (each element
corresponding to one contrast).  If \code{NULL}, no inference performed.}

\item{contrast_names}{(Optional) Names of contrasts.}

\item{gamma}{(For inference only) Activation threshold for the excursion set,
or a vector thereof (each element corresponding to one contrast). Default:
\code{0}.}

\item{alpha}{(For inference only) Significance level for activation for the
excursion set, or a vector thereof (each element corresponding to one
contrast). Default: \code{.05}.}

\item{nsamp_theta}{Number of theta values to sample from posterior. Default:
\code{50}.}

\item{nsamp_beta}{Number of beta vectors to sample conditional on each theta
value sampled. Default: \code{100}.}

\item{num_cores}{The number of cores to use for sampling betas in parallel. If
\code{NULL} (default), do not run in parallel.}

\item{verbose}{\code{1} (default) to print occasional updates during model
computation; \code{2} for occasional updates as well as running INLA in
verbose mode (if \code{Bayes}), or \code{0} for no printed updates.}
}
\value{
A list containing the estimates, PPMs and areas of activation for each contrast.
}
\description{
Performs group-level Bayesian GLM estimation and inference using the joint
approach described in Mejia et al. (2020).
}
\section{INLA Requirement}{

This function requires the \code{INLA} package, which is not a CRAN package.
See \url{https://www.r-inla.org/download-install} for easy installation instructions.
}

